// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package aiplatform

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	"github.com/golang/protobuf/proto"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	aiplatformpb "google.golang.org/genproto/googleapis/cloud/aiplatform/v1"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
)

var newPipelineClientHook clientHook

// PipelineCallOptions contains the retry settings for each method of PipelineClient.
type PipelineCallOptions struct {
	CreateTrainingPipeline []gax.CallOption
	GetTrainingPipeline    []gax.CallOption
	ListTrainingPipelines  []gax.CallOption
	DeleteTrainingPipeline []gax.CallOption
	CancelTrainingPipeline []gax.CallOption
}

func defaultPipelineGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("aiplatform.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("aiplatform.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://aiplatform.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		option.WithGRPCDialOption(grpc.WithDisableServiceConfig()),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultPipelineCallOptions() *PipelineCallOptions {
	return &PipelineCallOptions{
		CreateTrainingPipeline: []gax.CallOption{},
		GetTrainingPipeline:    []gax.CallOption{},
		ListTrainingPipelines:  []gax.CallOption{},
		DeleteTrainingPipeline: []gax.CallOption{},
		CancelTrainingPipeline: []gax.CallOption{},
	}
}

// internalPipelineClient is an interface that defines the methods availaible from Vertex AI API.
type internalPipelineClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateTrainingPipeline(context.Context, *aiplatformpb.CreateTrainingPipelineRequest, ...gax.CallOption) (*aiplatformpb.TrainingPipeline, error)
	GetTrainingPipeline(context.Context, *aiplatformpb.GetTrainingPipelineRequest, ...gax.CallOption) (*aiplatformpb.TrainingPipeline, error)
	ListTrainingPipelines(context.Context, *aiplatformpb.ListTrainingPipelinesRequest, ...gax.CallOption) *TrainingPipelineIterator
	DeleteTrainingPipeline(context.Context, *aiplatformpb.DeleteTrainingPipelineRequest, ...gax.CallOption) (*DeleteTrainingPipelineOperation, error)
	DeleteTrainingPipelineOperation(name string) *DeleteTrainingPipelineOperation
	CancelTrainingPipeline(context.Context, *aiplatformpb.CancelTrainingPipelineRequest, ...gax.CallOption) error
}

// PipelineClient is a client for interacting with Vertex AI API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// A service for creating and managing Vertex AI’s pipelines. This includes both
// TrainingPipeline resources (used for AutoML and custom training) and
// PipelineJob resources (used for Vertex Pipelines).
type PipelineClient struct {
	// The internal transport-dependent client.
	internalClient internalPipelineClient

	// The call options for this service.
	CallOptions *PipelineCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *PipelineClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *PipelineClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *PipelineClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateTrainingPipeline creates a TrainingPipeline. A created TrainingPipeline right away will be
// attempted to be run.
func (c *PipelineClient) CreateTrainingPipeline(ctx context.Context, req *aiplatformpb.CreateTrainingPipelineRequest, opts ...gax.CallOption) (*aiplatformpb.TrainingPipeline, error) {
	return c.internalClient.CreateTrainingPipeline(ctx, req, opts...)
}

// GetTrainingPipeline gets a TrainingPipeline.
func (c *PipelineClient) GetTrainingPipeline(ctx context.Context, req *aiplatformpb.GetTrainingPipelineRequest, opts ...gax.CallOption) (*aiplatformpb.TrainingPipeline, error) {
	return c.internalClient.GetTrainingPipeline(ctx, req, opts...)
}

// ListTrainingPipelines lists TrainingPipelines in a Location.
func (c *PipelineClient) ListTrainingPipelines(ctx context.Context, req *aiplatformpb.ListTrainingPipelinesRequest, opts ...gax.CallOption) *TrainingPipelineIterator {
	return c.internalClient.ListTrainingPipelines(ctx, req, opts...)
}

// DeleteTrainingPipeline deletes a TrainingPipeline.
func (c *PipelineClient) DeleteTrainingPipeline(ctx context.Context, req *aiplatformpb.DeleteTrainingPipelineRequest, opts ...gax.CallOption) (*DeleteTrainingPipelineOperation, error) {
	return c.internalClient.DeleteTrainingPipeline(ctx, req, opts...)
}

// DeleteTrainingPipelineOperation returns a new DeleteTrainingPipelineOperation from a given name.
// The name must be that of a previously created DeleteTrainingPipelineOperation, possibly from a different process.
func (c *PipelineClient) DeleteTrainingPipelineOperation(name string) *DeleteTrainingPipelineOperation {
	return c.internalClient.DeleteTrainingPipelineOperation(name)
}

// CancelTrainingPipeline cancels a TrainingPipeline.
// Starts asynchronous cancellation on the TrainingPipeline. The server
// makes a best effort to cancel the pipeline, but success is not
// guaranteed. Clients can use PipelineService.GetTrainingPipeline or
// other methods to check whether the cancellation succeeded or whether the
// pipeline completed despite cancellation. On successful cancellation,
// the TrainingPipeline is not deleted; instead it becomes a pipeline with
// a TrainingPipeline.error value with a google.rpc.Status.code of 1,
// corresponding to Code.CANCELLED, and TrainingPipeline.state is set to
// CANCELLED.
func (c *PipelineClient) CancelTrainingPipeline(ctx context.Context, req *aiplatformpb.CancelTrainingPipelineRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelTrainingPipeline(ctx, req, opts...)
}

// pipelineGRPCClient is a client for interacting with Vertex AI API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type pipelineGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing PipelineClient
	CallOptions **PipelineCallOptions

	// The gRPC API client.
	pipelineClient aiplatformpb.PipelineServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewPipelineClient creates a new pipeline service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// A service for creating and managing Vertex AI’s pipelines. This includes both
// TrainingPipeline resources (used for AutoML and custom training) and
// PipelineJob resources (used for Vertex Pipelines).
func NewPipelineClient(ctx context.Context, opts ...option.ClientOption) (*PipelineClient, error) {
	clientOpts := defaultPipelineGRPCClientOptions()
	if newPipelineClientHook != nil {
		hookOpts, err := newPipelineClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := PipelineClient{CallOptions: defaultPipelineCallOptions()}

	c := &pipelineGRPCClient{
		connPool:         connPool,
		disableDeadlines: disableDeadlines,
		pipelineClient:   aiplatformpb.NewPipelineServiceClient(connPool),
		CallOptions:      &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *pipelineGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *pipelineGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", versionClient, "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *pipelineGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *pipelineGRPCClient) CreateTrainingPipeline(ctx context.Context, req *aiplatformpb.CreateTrainingPipelineRequest, opts ...gax.CallOption) (*aiplatformpb.TrainingPipeline, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 5000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateTrainingPipeline[0:len((*c.CallOptions).CreateTrainingPipeline):len((*c.CallOptions).CreateTrainingPipeline)], opts...)
	var resp *aiplatformpb.TrainingPipeline
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.pipelineClient.CreateTrainingPipeline(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *pipelineGRPCClient) GetTrainingPipeline(ctx context.Context, req *aiplatformpb.GetTrainingPipelineRequest, opts ...gax.CallOption) (*aiplatformpb.TrainingPipeline, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 5000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetTrainingPipeline[0:len((*c.CallOptions).GetTrainingPipeline):len((*c.CallOptions).GetTrainingPipeline)], opts...)
	var resp *aiplatformpb.TrainingPipeline
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.pipelineClient.GetTrainingPipeline(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *pipelineGRPCClient) ListTrainingPipelines(ctx context.Context, req *aiplatformpb.ListTrainingPipelinesRequest, opts ...gax.CallOption) *TrainingPipelineIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListTrainingPipelines[0:len((*c.CallOptions).ListTrainingPipelines):len((*c.CallOptions).ListTrainingPipelines)], opts...)
	it := &TrainingPipelineIterator{}
	req = proto.Clone(req).(*aiplatformpb.ListTrainingPipelinesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*aiplatformpb.TrainingPipeline, string, error) {
		var resp *aiplatformpb.ListTrainingPipelinesResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.pipelineClient.ListTrainingPipelines(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTrainingPipelines(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()
	return it
}

func (c *pipelineGRPCClient) DeleteTrainingPipeline(ctx context.Context, req *aiplatformpb.DeleteTrainingPipelineRequest, opts ...gax.CallOption) (*DeleteTrainingPipelineOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 5000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteTrainingPipeline[0:len((*c.CallOptions).DeleteTrainingPipeline):len((*c.CallOptions).DeleteTrainingPipeline)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.pipelineClient.DeleteTrainingPipeline(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteTrainingPipelineOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *pipelineGRPCClient) CancelTrainingPipeline(ctx context.Context, req *aiplatformpb.CancelTrainingPipelineRequest, opts ...gax.CallOption) error {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 5000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CancelTrainingPipeline[0:len((*c.CallOptions).CancelTrainingPipeline):len((*c.CallOptions).CancelTrainingPipeline)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.pipelineClient.CancelTrainingPipeline(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

// DeleteTrainingPipelineOperation manages a long-running operation from DeleteTrainingPipeline.
type DeleteTrainingPipelineOperation struct {
	lro *longrunning.Operation
}

// DeleteTrainingPipelineOperation returns a new DeleteTrainingPipelineOperation from a given name.
// The name must be that of a previously created DeleteTrainingPipelineOperation, possibly from a different process.
func (c *pipelineGRPCClient) DeleteTrainingPipelineOperation(name string) *DeleteTrainingPipelineOperation {
	return &DeleteTrainingPipelineOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteTrainingPipelineOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteTrainingPipelineOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteTrainingPipelineOperation) Metadata() (*aiplatformpb.DeleteOperationMetadata, error) {
	var meta aiplatformpb.DeleteOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteTrainingPipelineOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteTrainingPipelineOperation) Name() string {
	return op.lro.Name()
}

// TrainingPipelineIterator manages a stream of *aiplatformpb.TrainingPipeline.
type TrainingPipelineIterator struct {
	items    []*aiplatformpb.TrainingPipeline
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*aiplatformpb.TrainingPipeline, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *TrainingPipelineIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TrainingPipelineIterator) Next() (*aiplatformpb.TrainingPipeline, error) {
	var item *aiplatformpb.TrainingPipeline
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TrainingPipelineIterator) bufLen() int {
	return len(it.items)
}

func (it *TrainingPipelineIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
