package edgeorder

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/edgeorder/mgmt/2020-12-01-preview/edgeorder"

// AddressDetails address details for an order item.
type AddressDetails struct {
	// ForwardAddress - Customer address and contact details. It should be address resource
	ForwardAddress *AddressProperties `json:"forwardAddress,omitempty"`
	// ReturnAddress - READ-ONLY; Return shipping address
	ReturnAddress *AddressProperties `json:"returnAddress,omitempty"`
}

// MarshalJSON is the custom marshaler for AddressDetails.
func (ad AddressDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ad.ForwardAddress != nil {
		objectMap["forwardAddress"] = ad.ForwardAddress
	}
	return json.Marshal(objectMap)
}

// AddressProperties address Properties
type AddressProperties struct {
	// ShippingAddress - Shipping details for the address
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// ContactDetails - Contact details for the address
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
}

// AddressResource address Resource.
type AddressResource struct {
	autorest.Response `json:"-"`
	// AddressProperties - Properties of an address.
	*AddressProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; Represents resource creation and update time
	SystemData *SystemData `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AddressResource.
func (ar AddressResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.AddressProperties != nil {
		objectMap["properties"] = ar.AddressProperties
	}
	if ar.Tags != nil {
		objectMap["tags"] = ar.Tags
	}
	if ar.Location != nil {
		objectMap["location"] = ar.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AddressResource struct.
func (ar *AddressResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var addressProperties AddressProperties
				err = json.Unmarshal(*v, &addressProperties)
				if err != nil {
					return err
				}
				ar.AddressProperties = &addressProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ar.SystemData = &systemData
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ar.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ar.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		}
	}

	return nil
}

// AddressResourceList address Resource Collection
type AddressResourceList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of address resources.
	Value *[]AddressResource `json:"value,omitempty"`
	// NextLink - Link for the next set of job resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AddressResourceList.
func (arl AddressResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arl.NextLink != nil {
		objectMap["nextLink"] = arl.NextLink
	}
	return json.Marshal(objectMap)
}

// AddressResourceListIterator provides access to a complete listing of AddressResource values.
type AddressResourceListIterator struct {
	i    int
	page AddressResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AddressResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddressResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AddressResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AddressResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AddressResourceListIterator) Response() AddressResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AddressResourceListIterator) Value() AddressResource {
	if !iter.page.NotDone() {
		return AddressResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AddressResourceListIterator type.
func NewAddressResourceListIterator(page AddressResourceListPage) AddressResourceListIterator {
	return AddressResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arl AddressResourceList) IsEmpty() bool {
	return arl.Value == nil || len(*arl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arl AddressResourceList) hasNextLink() bool {
	return arl.NextLink != nil && len(*arl.NextLink) != 0
}

// addressResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arl AddressResourceList) addressResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !arl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arl.NextLink)))
}

// AddressResourceListPage contains a page of AddressResource values.
type AddressResourceListPage struct {
	fn  func(context.Context, AddressResourceList) (AddressResourceList, error)
	arl AddressResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AddressResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddressResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arl)
		if err != nil {
			return err
		}
		page.arl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AddressResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AddressResourceListPage) NotDone() bool {
	return !page.arl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AddressResourceListPage) Response() AddressResourceList {
	return page.arl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AddressResourceListPage) Values() []AddressResource {
	if page.arl.IsEmpty() {
		return nil
	}
	return *page.arl.Value
}

// Creates a new instance of the AddressResourceListPage type.
func NewAddressResourceListPage(cur AddressResourceList, getNextPage func(context.Context, AddressResourceList) (AddressResourceList, error)) AddressResourceListPage {
	return AddressResourceListPage{
		fn:  getNextPage,
		arl: cur,
	}
}

// AddressUpdateParameter the Address update parameters
type AddressUpdateParameter struct {
	// AddressUpdateProperties - Properties of a address to be updated.
	*AddressUpdateProperties `json:"properties,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AddressUpdateParameter.
func (aup AddressUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aup.AddressUpdateProperties != nil {
		objectMap["properties"] = aup.AddressUpdateProperties
	}
	if aup.Tags != nil {
		objectMap["tags"] = aup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AddressUpdateParameter struct.
func (aup *AddressUpdateParameter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var addressUpdateProperties AddressUpdateProperties
				err = json.Unmarshal(*v, &addressUpdateProperties)
				if err != nil {
					return err
				}
				aup.AddressUpdateProperties = &addressUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				aup.Tags = tags
			}
		}
	}

	return nil
}

// AddressUpdateProperties address Properties
type AddressUpdateProperties struct {
	// ShippingAddress - Shipping details for the address
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// ContactDetails - Contact details for the address
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
}

// AvailabilityInformation availability information of a product system.
type AvailabilityInformation struct {
	// AvailabilityStage - READ-ONLY; Current availability stage of the product. Availability stage. Possible values include: 'AvailabilityStageAvailable', 'AvailabilityStageComingSoon', 'AvailabilityStagePreview', 'AvailabilityStageDeprecated', 'AvailabilityStageSignup', 'AvailabilityStageUnavailable'
	AvailabilityStage AvailabilityStage `json:"availabilityStage,omitempty"`
	// DisabledReason - READ-ONLY; Reason why the product is disabled. Possible values include: 'DisabledReasonNone', 'DisabledReasonCountry', 'DisabledReasonRegion', 'DisabledReasonFeature', 'DisabledReasonOfferType', 'DisabledReasonNoSubscriptionInfo', 'DisabledReasonNotAvailable', 'DisabledReasonOutOfStock'
	DisabledReason DisabledReason `json:"disabledReason,omitempty"`
	// DisabledReasonMessage - READ-ONLY; Message for why the product is disabled.
	DisabledReasonMessage *string `json:"disabledReasonMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailabilityInformation.
func (ai AvailabilityInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BasicInformation basic information for any product system
type BasicInformation struct {
	// DisplayName - READ-ONLY; Display Name for the product system.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; Description related to the product system.
	Description *Description `json:"description,omitempty"`
	// ImageInformation - READ-ONLY; Image information for the product system.
	ImageInformation *[]ImageInformation `json:"imageInformation,omitempty"`
	// CostInformation - READ-ONLY; Cost information for the product system.
	CostInformation *CostInformation `json:"costInformation,omitempty"`
	// AvailabilityInformation - READ-ONLY; Availability information of the product system.
	AvailabilityInformation *AvailabilityInformation `json:"availabilityInformation,omitempty"`
	// HierarchyInformation - READ-ONLY; Hierarchy information of a product.
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty"`
}

// MarshalJSON is the custom marshaler for BasicInformation.
func (bi BasicInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BillingMeterDetails holds billing meter details for each type of billing
type BillingMeterDetails struct {
	// Name - READ-ONLY; Represents Billing type name
	Name *string `json:"name,omitempty"`
	// MeterDetails - READ-ONLY; Represents MeterDetails
	MeterDetails BasicMeterDetails `json:"meterDetails,omitempty"`
	// MeteringType - READ-ONLY; Represents Metering type (eg one-time or recurrent). Possible values include: 'MeteringTypeOneTime', 'MeteringTypeRecurring', 'MeteringTypeAdhoc'
	MeteringType MeteringType `json:"meteringType,omitempty"`
	// Frequency - READ-ONLY; Frequency of recurrence
	Frequency *string `json:"frequency,omitempty"`
}

// MarshalJSON is the custom marshaler for BillingMeterDetails.
func (bmd BillingMeterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BillingMeterDetails struct.
func (bmd *BillingMeterDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bmd.Name = &name
			}
		case "meterDetails":
			if v != nil {
				meterDetails, err := unmarshalBasicMeterDetails(*v)
				if err != nil {
					return err
				}
				bmd.MeterDetails = meterDetails
			}
		case "meteringType":
			if v != nil {
				var meteringType MeteringType
				err = json.Unmarshal(*v, &meteringType)
				if err != nil {
					return err
				}
				bmd.MeteringType = meteringType
			}
		case "frequency":
			if v != nil {
				var frequency string
				err = json.Unmarshal(*v, &frequency)
				if err != nil {
					return err
				}
				bmd.Frequency = &frequency
			}
		}
	}

	return nil
}

// CancellationReason reason for cancellation.
type CancellationReason struct {
	// Reason - Reason for cancellation.
	Reason *string `json:"reason,omitempty"`
}

// CommonProperties represents common properties across product hierarchy
type CommonProperties struct {
	// FilterableProperties - READ-ONLY; list of filters supported for a product
	FilterableProperties *[]FilterableProperty `json:"filterableProperties,omitempty"`
	// DisplayName - READ-ONLY; Display Name for the product system.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; Description related to the product system.
	Description *Description `json:"description,omitempty"`
	// ImageInformation - READ-ONLY; Image information for the product system.
	ImageInformation *[]ImageInformation `json:"imageInformation,omitempty"`
	// CostInformation - READ-ONLY; Cost information for the product system.
	CostInformation *CostInformation `json:"costInformation,omitempty"`
	// AvailabilityInformation - READ-ONLY; Availability information of the product system.
	AvailabilityInformation *AvailabilityInformation `json:"availabilityInformation,omitempty"`
	// HierarchyInformation - READ-ONLY; Hierarchy information of a product.
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty"`
}

// MarshalJSON is the custom marshaler for CommonProperties.
func (cp CommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Configuration configuration object.
type Configuration struct {
	// ConfigurationProperties - READ-ONLY; Properties of configuration
	*ConfigurationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Configuration.
func (c Configuration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Configuration struct.
func (c *Configuration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var configurationProperties ConfigurationProperties
				err = json.Unmarshal(*v, &configurationProperties)
				if err != nil {
					return err
				}
				c.ConfigurationProperties = &configurationProperties
			}
		}
	}

	return nil
}

// ConfigurationFilters configuration filters
type ConfigurationFilters struct {
	// HierarchyInformation - Product hierarchy information
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty"`
	// FilterableProperty - Filters specific to product
	FilterableProperty *[]FilterableProperty `json:"filterableProperty,omitempty"`
}

// ConfigurationProperties properties of configuration
type ConfigurationProperties struct {
	// Specifications - READ-ONLY; Specifications of the configuration
	Specifications *[]Specification `json:"specifications,omitempty"`
	// Dimensions - READ-ONLY; Dimensions of the configuration
	Dimensions *Dimensions `json:"dimensions,omitempty"`
	// FilterableProperties - READ-ONLY; list of filters supported for a product
	FilterableProperties *[]FilterableProperty `json:"filterableProperties,omitempty"`
	// DisplayName - READ-ONLY; Display Name for the product system.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; Description related to the product system.
	Description *Description `json:"description,omitempty"`
	// ImageInformation - READ-ONLY; Image information for the product system.
	ImageInformation *[]ImageInformation `json:"imageInformation,omitempty"`
	// CostInformation - READ-ONLY; Cost information for the product system.
	CostInformation *CostInformation `json:"costInformation,omitempty"`
	// AvailabilityInformation - READ-ONLY; Availability information of the product system.
	AvailabilityInformation *AvailabilityInformation `json:"availabilityInformation,omitempty"`
	// HierarchyInformation - READ-ONLY; Hierarchy information of a product.
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationProperties.
func (cp ConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Configurations the list of configurations.
type Configurations struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of configurations.
	Value *[]Configuration `json:"value,omitempty"`
	// NextLink - Link for the next set of configurations.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for Configurations.
func (c Configurations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.NextLink != nil {
		objectMap["nextLink"] = c.NextLink
	}
	return json.Marshal(objectMap)
}

// ConfigurationsIterator provides access to a complete listing of Configuration values.
type ConfigurationsIterator struct {
	i    int
	page ConfigurationsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConfigurationsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConfigurationsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConfigurationsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConfigurationsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConfigurationsIterator) Response() Configurations {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConfigurationsIterator) Value() Configuration {
	if !iter.page.NotDone() {
		return Configuration{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConfigurationsIterator type.
func NewConfigurationsIterator(page ConfigurationsPage) ConfigurationsIterator {
	return ConfigurationsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (c Configurations) IsEmpty() bool {
	return c.Value == nil || len(*c.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (c Configurations) hasNextLink() bool {
	return c.NextLink != nil && len(*c.NextLink) != 0
}

// configurationsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (c Configurations) configurationsPreparer(ctx context.Context) (*http.Request, error) {
	if !c.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(c.NextLink)))
}

// ConfigurationsPage contains a page of Configuration values.
type ConfigurationsPage struct {
	fn func(context.Context, Configurations) (Configurations, error)
	c  Configurations
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConfigurationsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConfigurationsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.c)
		if err != nil {
			return err
		}
		page.c = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConfigurationsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConfigurationsPage) NotDone() bool {
	return !page.c.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConfigurationsPage) Response() Configurations {
	return page.c
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConfigurationsPage) Values() []Configuration {
	if page.c.IsEmpty() {
		return nil
	}
	return *page.c.Value
}

// Creates a new instance of the ConfigurationsPage type.
func NewConfigurationsPage(cur Configurations, getNextPage func(context.Context, Configurations) (Configurations, error)) ConfigurationsPage {
	return ConfigurationsPage{
		fn: getNextPage,
		c:  cur,
	}
}

// ConfigurationsRequest configuration request object.
type ConfigurationsRequest struct {
	// ConfigurationFilters - Holds details about product hierarchy information and filterable property.
	ConfigurationFilters *[]ConfigurationFilters `json:"configurationFilters,omitempty"`
	// CustomerSubscriptionDetails - Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details
	CustomerSubscriptionDetails *CustomerSubscriptionDetails `json:"customerSubscriptionDetails,omitempty"`
}

// ContactDetails contact Details.
type ContactDetails struct {
	// ContactName - Contact name of the person.
	ContactName *string `json:"contactName,omitempty"`
	// Phone - Phone number of the contact person.
	Phone *string `json:"phone,omitempty"`
	// PhoneExtension - Phone extension number of the contact person.
	PhoneExtension *string `json:"phoneExtension,omitempty"`
	// Mobile - Mobile number of the contact person.
	Mobile *string `json:"mobile,omitempty"`
	// EmailList - List of Email-ids to be notified about job progress.
	EmailList *[]string `json:"emailList,omitempty"`
}

// CostInformation cost information for the product system
type CostInformation struct {
	// BillingMeterDetails - READ-ONLY; Details on the various billing aspects for the product system.
	BillingMeterDetails *[]BillingMeterDetails `json:"billingMeterDetails,omitempty"`
	// BillingInfoURL - READ-ONLY; Default url to display billing information
	BillingInfoURL *string `json:"billingInfoUrl,omitempty"`
}

// MarshalJSON is the custom marshaler for CostInformation.
func (ci CostInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CreateAddressFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CreateAddressFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BaseClient) (AddressResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CreateAddressFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CreateAddressFuture.Result.
func (future *CreateAddressFuture) result(client BaseClient) (ar AddressResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.CreateAddressFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("edgeorder.CreateAddressFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ar.Response.Response, err = future.GetResult(sender); err == nil && ar.Response.Response.StatusCode != http.StatusNoContent {
		ar, err = client.CreateAddressResponder(ar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "edgeorder.CreateAddressFuture", "Result", ar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CreateOrderItemFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CreateOrderItemFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BaseClient) (OrderItemResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CreateOrderItemFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CreateOrderItemFuture.Result.
func (future *CreateOrderItemFuture) result(client BaseClient) (oir OrderItemResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.CreateOrderItemFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		oir.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("edgeorder.CreateOrderItemFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if oir.Response.Response, err = future.GetResult(sender); err == nil && oir.Response.Response.StatusCode != http.StatusNoContent {
		oir, err = client.CreateOrderItemResponder(oir.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "edgeorder.CreateOrderItemFuture", "Result", oir.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CustomerSubscriptionDetails holds Customer subscription details. Clients can display available products
// to unregistered customers by explicitly passing subscription details
type CustomerSubscriptionDetails struct {
	// RegisteredFeatures - List of registered feature flags for subscription
	RegisteredFeatures *[]CustomerSubscriptionRegisteredFeatures `json:"registeredFeatures,omitempty"`
	// LocationPlacementID - Location placement Id of a subscription
	LocationPlacementID *string `json:"locationPlacementId,omitempty"`
	// QuotaID - Quota ID of a subscription
	QuotaID *string `json:"quotaId,omitempty"`
}

// CustomerSubscriptionRegisteredFeatures represents subscription registered features
type CustomerSubscriptionRegisteredFeatures struct {
	// Name - Name of subscription registered feature
	Name *string `json:"name,omitempty"`
	// State - State of subscription registered feature
	State *string `json:"state,omitempty"`
}

// DeleteAddressByNameFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeleteAddressByNameFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BaseClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeleteAddressByNameFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeleteAddressByNameFuture.Result.
func (future *DeleteAddressByNameFuture) result(client BaseClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.DeleteAddressByNameFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("edgeorder.DeleteAddressByNameFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeleteOrderItemByNameFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeleteOrderItemByNameFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BaseClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeleteOrderItemByNameFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeleteOrderItemByNameFuture.Result.
func (future *DeleteOrderItemByNameFuture) result(client BaseClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.DeleteOrderItemByNameFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("edgeorder.DeleteOrderItemByNameFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Description description related properties of a product system.
type Description struct {
	// DescriptionType - READ-ONLY; Type of description. Possible values include: 'DescriptionTypeBase'
	DescriptionType DescriptionType `json:"descriptionType,omitempty"`
	// ShortDescription - READ-ONLY; Short description of the product system.
	ShortDescription *string `json:"shortDescription,omitempty"`
	// LongDescription - READ-ONLY; Long description of the product system.
	LongDescription *string `json:"longDescription,omitempty"`
	// Keywords - READ-ONLY; Keywords for the product system.
	Keywords *[]string `json:"keywords,omitempty"`
	// Attributes - READ-ONLY; Attributes for the product system.
	Attributes *[]string `json:"attributes,omitempty"`
	// Links - READ-ONLY; Links for the product system.
	Links *[]Link `json:"links,omitempty"`
}

// MarshalJSON is the custom marshaler for Description.
func (d Description) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeviceDetails device details.
type DeviceDetails struct {
	// SerialNumber - READ-ONLY; device serial number
	SerialNumber *string `json:"serialNumber,omitempty"`
	// ManagementResourceID - READ-ONLY; Management Resource Id
	ManagementResourceID *string `json:"managementResourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceDetails.
func (dd DeviceDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Dimensions dimensions of a configuration.
type Dimensions struct {
	// Length - READ-ONLY; Length of the device.
	Length *float64 `json:"length,omitempty"`
	// Height - READ-ONLY; Height of the device.
	Height *float64 `json:"height,omitempty"`
	// Width - READ-ONLY; Width of the device.
	Width *float64 `json:"width,omitempty"`
	// LengthHeightUnit - READ-ONLY; Unit for the dimensions of length, height and width. Possible values include: 'LengthHeightUnitIN', 'LengthHeightUnitCM'
	LengthHeightUnit LengthHeightUnit `json:"lengthHeightUnit,omitempty"`
	// Weight - READ-ONLY; Weight of the device.
	Weight *float64 `json:"weight,omitempty"`
	// Depth - READ-ONLY; Depth of the device.
	Depth *float64 `json:"depth,omitempty"`
	// WeightUnit - READ-ONLY; Unit for the dimensions of weight. Possible values include: 'WeightMeasurementUnitLBS', 'WeightMeasurementUnitKGS'
	WeightUnit WeightMeasurementUnit `json:"weightUnit,omitempty"`
}

// MarshalJSON is the custom marshaler for Dimensions.
func (d Dimensions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DisplayInfo describes product display information
type DisplayInfo struct {
	// ProductFamilyDisplayName - READ-ONLY; Product family display name
	ProductFamilyDisplayName *string `json:"productFamilyDisplayName,omitempty"`
	// ConfigurationDisplayName - READ-ONLY; Configuration display name
	ConfigurationDisplayName *string `json:"configurationDisplayName,omitempty"`
}

// MarshalJSON is the custom marshaler for DisplayInfo.
func (di DisplayInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EncryptionPreferences preferences related to the double encryption
type EncryptionPreferences struct {
	// DoubleEncryptionStatus - Defines secondary layer of software-based encryption enablement. Possible values include: 'DoubleEncryptionStatusDisabled', 'DoubleEncryptionStatusEnabled'
	DoubleEncryptionStatus DoubleEncryptionStatus `json:"doubleEncryptionStatus,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// FilterableProperty different types of filters supported and its values.
type FilterableProperty struct {
	// Type - Type of product filter. Possible values include: 'SupportedFilterTypesShipToCountries', 'SupportedFilterTypesDoubleEncryptionStatus'
	Type SupportedFilterTypes `json:"type,omitempty"`
	// SupportedValues - Values to be filtered.
	SupportedValues *[]string `json:"supportedValues,omitempty"`
}

// HierarchyInformation holds details about product hierarchy information
type HierarchyInformation struct {
	// ProductFamilyName - Represents product family name that uniquely identifies product family
	ProductFamilyName *string `json:"productFamilyName,omitempty"`
	// ProductLineName - Represents product line name that uniquely identifies product line
	ProductLineName *string `json:"productLineName,omitempty"`
	// ProductName - Represents product name that uniquely identifies product
	ProductName *string `json:"productName,omitempty"`
	// ConfigurationName - Represents configuration name that uniquely identifies configuration
	ConfigurationName *string `json:"configurationName,omitempty"`
}

// ImageInformation image for the product
type ImageInformation struct {
	// ImageType - READ-ONLY; Type of the image. Possible values include: 'ImageTypeMainImage', 'ImageTypeBulletImage', 'ImageTypeGenericImage'
	ImageType ImageType `json:"imageType,omitempty"`
	// ImageURL - READ-ONLY; Url of the image
	ImageURL *string `json:"imageUrl,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageInformation.
func (ii ImageInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Link returns link related to the product
type Link struct {
	// LinkType - READ-ONLY; Type of link. Possible values include: 'LinkTypeGeneric', 'LinkTypeTermsAndConditions', 'LinkTypeSpecification', 'LinkTypeDocumentation', 'LinkTypeKnowMore', 'LinkTypeSignUp'
	LinkType LinkType `json:"linkType,omitempty"`
	// LinkURL - READ-ONLY; Url of the link
	LinkURL *string `json:"linkUrl,omitempty"`
}

// MarshalJSON is the custom marshaler for Link.
func (l Link) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagementResourcePreferences management resource preference to link device
type ManagementResourcePreferences struct {
	// PreferredManagementResourceID - Customer preferred Management resource ARM ID
	PreferredManagementResourceID *string `json:"preferredManagementResourceId,omitempty"`
}

// BasicMeterDetails holds details about billing type and its meter guids
type BasicMeterDetails interface {
	AsPav2MeterDetails() (*Pav2MeterDetails, bool)
	AsPurchaseMeterDetails() (*PurchaseMeterDetails, bool)
	AsMeterDetails() (*MeterDetails, bool)
}

// MeterDetails holds details about billing type and its meter guids
type MeterDetails struct {
	// Multiplier - READ-ONLY; Billing unit applicable for Pav2 billing
	Multiplier *float64 `json:"multiplier,omitempty"`
	// ChargingType - READ-ONLY; Charging type. Possible values include: 'ChargingTypePerOrder', 'ChargingTypePerDevice'
	ChargingType ChargingType `json:"chargingType,omitempty"`
	// BillingType - Possible values include: 'BillingTypeMeterDetails', 'BillingTypePav2', 'BillingTypePurchase'
	BillingType BillingType `json:"billingType,omitempty"`
}

func unmarshalBasicMeterDetails(body []byte) (BasicMeterDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["billingType"] {
	case string(BillingTypePav2):
		var p2md Pav2MeterDetails
		err := json.Unmarshal(body, &p2md)
		return p2md, err
	case string(BillingTypePurchase):
		var pmd PurchaseMeterDetails
		err := json.Unmarshal(body, &pmd)
		return pmd, err
	default:
		var md MeterDetails
		err := json.Unmarshal(body, &md)
		return md, err
	}
}
func unmarshalBasicMeterDetailsArray(body []byte) ([]BasicMeterDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mdArray := make([]BasicMeterDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		md, err := unmarshalBasicMeterDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		mdArray[index] = md
	}
	return mdArray, nil
}

// MarshalJSON is the custom marshaler for MeterDetails.
func (md MeterDetails) MarshalJSON() ([]byte, error) {
	md.BillingType = BillingTypeMeterDetails
	objectMap := make(map[string]interface{})
	if md.BillingType != "" {
		objectMap["billingType"] = md.BillingType
	}
	return json.Marshal(objectMap)
}

// AsPav2MeterDetails is the BasicMeterDetails implementation for MeterDetails.
func (md MeterDetails) AsPav2MeterDetails() (*Pav2MeterDetails, bool) {
	return nil, false
}

// AsPurchaseMeterDetails is the BasicMeterDetails implementation for MeterDetails.
func (md MeterDetails) AsPurchaseMeterDetails() (*PurchaseMeterDetails, bool) {
	return nil, false
}

// AsMeterDetails is the BasicMeterDetails implementation for MeterDetails.
func (md MeterDetails) AsMeterDetails() (*MeterDetails, bool) {
	return &md, true
}

// AsBasicMeterDetails is the BasicMeterDetails implementation for MeterDetails.
func (md MeterDetails) AsBasicMeterDetails() (BasicMeterDetails, bool) {
	return &md, true
}

// NotificationPreference notification preference for a job stage.
type NotificationPreference struct {
	// StageName - Name of the stage. Possible values include: 'NotificationStageNameShipped', 'NotificationStageNameDelivered'
	StageName NotificationStageName `json:"stageName,omitempty"`
	// SendNotification - Notification is required or not.
	SendNotification *bool `json:"sendNotification,omitempty"`
}

// Operation details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Name - READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty"`
	// IsDataAction - READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane operations.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default value is "user,system". Possible values include: 'OriginUser', 'OriginSystem', 'OriginUsersystem'
	Origin Origin `json:"origin,omitempty"`
	// ActionType - READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs. Possible values include: 'ActionTypeInternal'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay localized display information for this particular operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft Compute".
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job Schedule Collections".
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult a list of REST API operations supported by an Azure Resource Provider. It contains
// an URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations supported by the resource provider
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OrderItemDetails order item details
type OrderItemDetails struct {
	// ProductDetails - Unique identifier for configuration.
	ProductDetails *ProductDetails `json:"productDetails,omitempty"`
	// OrderItemType - Order item type. Possible values include: 'OrderItemTypePurchase', 'OrderItemTypeRental'
	OrderItemType OrderItemType `json:"orderItemType,omitempty"`
	// CurrentStage - READ-ONLY; Current Order item Status
	CurrentStage *StageDetails `json:"currentStage,omitempty"`
	// OrderItemStageHistory - READ-ONLY; Order item status history
	OrderItemStageHistory *[]StageDetails `json:"orderItemStageHistory,omitempty"`
	// Preferences - Customer notification Preferences
	Preferences *Preferences `json:"preferences,omitempty"`
	// ForwardShippingDetails - READ-ONLY; Forward Package Shipping details
	ForwardShippingDetails *ShippingDetails `json:"forwardShippingDetails,omitempty"`
	// ReverseShippingDetails - READ-ONLY; Reverse Package Shipping details
	ReverseShippingDetails *ShippingDetails `json:"reverseShippingDetails,omitempty"`
	// NotificationEmailList - Additional notification email list
	NotificationEmailList *[]string `json:"notificationEmailList,omitempty"`
	// CancellationReason - READ-ONLY; Cancellation reason.
	CancellationReason *string `json:"cancellationReason,omitempty"`
	// CancellationStatus - READ-ONLY; Describes whether the orderItem is cancellable or not. Possible values include: 'OrderItemCancellationEnumCancellable', 'OrderItemCancellationEnumCancellableWithFee', 'OrderItemCancellationEnumNotCancellable'
	CancellationStatus OrderItemCancellationEnum `json:"cancellationStatus,omitempty"`
	// DeletionStatus - READ-ONLY; Describes whether the order item is deletable or not. Possible values include: 'ActionStatusEnumAllowed', 'ActionStatusEnumNotAllowed'
	DeletionStatus ActionStatusEnum `json:"deletionStatus,omitempty"`
	// ReturnReason - READ-ONLY; Return reason.
	ReturnReason *string `json:"returnReason,omitempty"`
	// ReturnStatus - READ-ONLY; Describes whether the orderItem is returnable or not. Possible values include: 'OrderItemReturnEnumReturnable', 'OrderItemReturnEnumReturnableWithFee', 'OrderItemReturnEnumNotReturnable'
	ReturnStatus OrderItemReturnEnum `json:"returnStatus,omitempty"`
	// ManagementRpDetails - READ-ONLY; parent RP details
	ManagementRpDetails interface{} `json:"managementRpDetails,omitempty"`
	// Error - READ-ONLY; Top level error for the job.
	Error *ErrorDetail `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for OrderItemDetails.
func (oid OrderItemDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oid.ProductDetails != nil {
		objectMap["productDetails"] = oid.ProductDetails
	}
	if oid.OrderItemType != "" {
		objectMap["orderItemType"] = oid.OrderItemType
	}
	if oid.Preferences != nil {
		objectMap["preferences"] = oid.Preferences
	}
	if oid.NotificationEmailList != nil {
		objectMap["notificationEmailList"] = oid.NotificationEmailList
	}
	return json.Marshal(objectMap)
}

// OrderItemProperties represents order item details.
type OrderItemProperties struct {
	// OrderItemDetails - Represents order item details.
	OrderItemDetails *OrderItemDetails `json:"orderItemDetails,omitempty"`
	// AddressDetails - Represents shipping and return address for order item
	AddressDetails *AddressDetails `json:"addressDetails,omitempty"`
	// StartTime - READ-ONLY; Start time of order item
	StartTime *date.Time `json:"startTime,omitempty"`
	// OrderID - Id of the order to which order item belongs to
	OrderID *string `json:"orderId,omitempty"`
}

// MarshalJSON is the custom marshaler for OrderItemProperties.
func (oip OrderItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oip.OrderItemDetails != nil {
		objectMap["orderItemDetails"] = oip.OrderItemDetails
	}
	if oip.AddressDetails != nil {
		objectMap["addressDetails"] = oip.AddressDetails
	}
	if oip.OrderID != nil {
		objectMap["orderId"] = oip.OrderID
	}
	return json.Marshal(objectMap)
}

// OrderItemResource represents order item contract
type OrderItemResource struct {
	autorest.Response `json:"-"`
	// OrderItemProperties - Order item properties
	*OrderItemProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; Represents resource creation and update time
	SystemData *SystemData `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for OrderItemResource.
func (oir OrderItemResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oir.OrderItemProperties != nil {
		objectMap["properties"] = oir.OrderItemProperties
	}
	if oir.Tags != nil {
		objectMap["tags"] = oir.Tags
	}
	if oir.Location != nil {
		objectMap["location"] = oir.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OrderItemResource struct.
func (oir *OrderItemResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var orderItemProperties OrderItemProperties
				err = json.Unmarshal(*v, &orderItemProperties)
				if err != nil {
					return err
				}
				oir.OrderItemProperties = &orderItemProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				oir.SystemData = &systemData
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				oir.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				oir.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				oir.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				oir.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				oir.Type = &typeVar
			}
		}
	}

	return nil
}

// OrderItemResourceList list of orderItems.
type OrderItemResourceList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of order item resources.
	Value *[]OrderItemResource `json:"value,omitempty"`
	// NextLink - Link for the next set of order item resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OrderItemResourceList.
func (oirl OrderItemResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oirl.NextLink != nil {
		objectMap["nextLink"] = oirl.NextLink
	}
	return json.Marshal(objectMap)
}

// OrderItemResourceListIterator provides access to a complete listing of OrderItemResource values.
type OrderItemResourceListIterator struct {
	i    int
	page OrderItemResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OrderItemResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderItemResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OrderItemResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OrderItemResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OrderItemResourceListIterator) Response() OrderItemResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OrderItemResourceListIterator) Value() OrderItemResource {
	if !iter.page.NotDone() {
		return OrderItemResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OrderItemResourceListIterator type.
func NewOrderItemResourceListIterator(page OrderItemResourceListPage) OrderItemResourceListIterator {
	return OrderItemResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oirl OrderItemResourceList) IsEmpty() bool {
	return oirl.Value == nil || len(*oirl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oirl OrderItemResourceList) hasNextLink() bool {
	return oirl.NextLink != nil && len(*oirl.NextLink) != 0
}

// orderItemResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oirl OrderItemResourceList) orderItemResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !oirl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oirl.NextLink)))
}

// OrderItemResourceListPage contains a page of OrderItemResource values.
type OrderItemResourceListPage struct {
	fn   func(context.Context, OrderItemResourceList) (OrderItemResourceList, error)
	oirl OrderItemResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OrderItemResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderItemResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oirl)
		if err != nil {
			return err
		}
		page.oirl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OrderItemResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OrderItemResourceListPage) NotDone() bool {
	return !page.oirl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OrderItemResourceListPage) Response() OrderItemResourceList {
	return page.oirl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OrderItemResourceListPage) Values() []OrderItemResource {
	if page.oirl.IsEmpty() {
		return nil
	}
	return *page.oirl.Value
}

// Creates a new instance of the OrderItemResourceListPage type.
func NewOrderItemResourceListPage(cur OrderItemResourceList, getNextPage func(context.Context, OrderItemResourceList) (OrderItemResourceList, error)) OrderItemResourceListPage {
	return OrderItemResourceListPage{
		fn:   getNextPage,
		oirl: cur,
	}
}

// OrderItemUpdateParameter updates order item parameters.
type OrderItemUpdateParameter struct {
	// OrderItemUpdateProperties - Order item update properties
	*OrderItemUpdateProperties `json:"properties,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for OrderItemUpdateParameter.
func (oiup OrderItemUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oiup.OrderItemUpdateProperties != nil {
		objectMap["properties"] = oiup.OrderItemUpdateProperties
	}
	if oiup.Tags != nil {
		objectMap["tags"] = oiup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OrderItemUpdateParameter struct.
func (oiup *OrderItemUpdateParameter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var orderItemUpdateProperties OrderItemUpdateProperties
				err = json.Unmarshal(*v, &orderItemUpdateProperties)
				if err != nil {
					return err
				}
				oiup.OrderItemUpdateProperties = &orderItemUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				oiup.Tags = tags
			}
		}
	}

	return nil
}

// OrderItemUpdateProperties order item update properties.
type OrderItemUpdateProperties struct {
	// ForwardAddress - Updates forward shipping address and contact details.
	ForwardAddress *AddressProperties `json:"forwardAddress,omitempty"`
	// Preferences - Customer preference.
	Preferences *Preferences `json:"preferences,omitempty"`
	// NotificationEmailList - Additional notification email list.
	NotificationEmailList *[]string `json:"notificationEmailList,omitempty"`
}

// OrderProperties represents order details.
type OrderProperties struct {
	// OrderItemIds - READ-ONLY; List of order item ARM Ids which are part of an order.
	OrderItemIds *[]string `json:"orderItemIds,omitempty"`
	// CurrentStage - READ-ONLY; Order current status.
	CurrentStage *StageDetails `json:"currentStage,omitempty"`
	// OrderStageHistory - READ-ONLY; Order status history.
	OrderStageHistory *[]StageDetails `json:"orderStageHistory,omitempty"`
}

// MarshalJSON is the custom marshaler for OrderProperties.
func (op OrderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OrderResource specifies the properties or parameters for an order. Order is a grouping of one or more
// order items.
type OrderResource struct {
	autorest.Response `json:"-"`
	// OrderProperties - Order properties
	*OrderProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; Represents resource creation and update time
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for OrderResource.
func (or OrderResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if or.OrderProperties != nil {
		objectMap["properties"] = or.OrderProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OrderResource struct.
func (or *OrderResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var orderProperties OrderProperties
				err = json.Unmarshal(*v, &orderProperties)
				if err != nil {
					return err
				}
				or.OrderProperties = &orderProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				or.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				or.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				or.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				or.Type = &typeVar
			}
		}
	}

	return nil
}

// OrderResourceList list of orders.
type OrderResourceList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of order resources.
	Value *[]OrderResource `json:"value,omitempty"`
	// NextLink - Link for the next set of order resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OrderResourceList.
func (orl OrderResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if orl.NextLink != nil {
		objectMap["nextLink"] = orl.NextLink
	}
	return json.Marshal(objectMap)
}

// OrderResourceListIterator provides access to a complete listing of OrderResource values.
type OrderResourceListIterator struct {
	i    int
	page OrderResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OrderResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OrderResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OrderResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OrderResourceListIterator) Response() OrderResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OrderResourceListIterator) Value() OrderResource {
	if !iter.page.NotDone() {
		return OrderResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OrderResourceListIterator type.
func NewOrderResourceListIterator(page OrderResourceListPage) OrderResourceListIterator {
	return OrderResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (orl OrderResourceList) IsEmpty() bool {
	return orl.Value == nil || len(*orl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (orl OrderResourceList) hasNextLink() bool {
	return orl.NextLink != nil && len(*orl.NextLink) != 0
}

// orderResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (orl OrderResourceList) orderResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !orl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(orl.NextLink)))
}

// OrderResourceListPage contains a page of OrderResource values.
type OrderResourceListPage struct {
	fn  func(context.Context, OrderResourceList) (OrderResourceList, error)
	orl OrderResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OrderResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrderResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.orl)
		if err != nil {
			return err
		}
		page.orl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OrderResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OrderResourceListPage) NotDone() bool {
	return !page.orl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OrderResourceListPage) Response() OrderResourceList {
	return page.orl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OrderResourceListPage) Values() []OrderResource {
	if page.orl.IsEmpty() {
		return nil
	}
	return *page.orl.Value
}

// Creates a new instance of the OrderResourceListPage type.
func NewOrderResourceListPage(cur OrderResourceList, getNextPage func(context.Context, OrderResourceList) (OrderResourceList, error)) OrderResourceListPage {
	return OrderResourceListPage{
		fn:  getNextPage,
		orl: cur,
	}
}

// Pav2MeterDetails billing type PAV2 meter details
type Pav2MeterDetails struct {
	// MeterGUID - READ-ONLY; Validation status of requested data center and transport.
	MeterGUID *string `json:"meterGuid,omitempty"`
	// Multiplier - READ-ONLY; Billing unit applicable for Pav2 billing
	Multiplier *float64 `json:"multiplier,omitempty"`
	// ChargingType - READ-ONLY; Charging type. Possible values include: 'ChargingTypePerOrder', 'ChargingTypePerDevice'
	ChargingType ChargingType `json:"chargingType,omitempty"`
	// BillingType - Possible values include: 'BillingTypeMeterDetails', 'BillingTypePav2', 'BillingTypePurchase'
	BillingType BillingType `json:"billingType,omitempty"`
}

// MarshalJSON is the custom marshaler for Pav2MeterDetails.
func (p2md Pav2MeterDetails) MarshalJSON() ([]byte, error) {
	p2md.BillingType = BillingTypePav2
	objectMap := make(map[string]interface{})
	if p2md.BillingType != "" {
		objectMap["billingType"] = p2md.BillingType
	}
	return json.Marshal(objectMap)
}

// AsPav2MeterDetails is the BasicMeterDetails implementation for Pav2MeterDetails.
func (p2md Pav2MeterDetails) AsPav2MeterDetails() (*Pav2MeterDetails, bool) {
	return &p2md, true
}

// AsPurchaseMeterDetails is the BasicMeterDetails implementation for Pav2MeterDetails.
func (p2md Pav2MeterDetails) AsPurchaseMeterDetails() (*PurchaseMeterDetails, bool) {
	return nil, false
}

// AsMeterDetails is the BasicMeterDetails implementation for Pav2MeterDetails.
func (p2md Pav2MeterDetails) AsMeterDetails() (*MeterDetails, bool) {
	return nil, false
}

// AsBasicMeterDetails is the BasicMeterDetails implementation for Pav2MeterDetails.
func (p2md Pav2MeterDetails) AsBasicMeterDetails() (BasicMeterDetails, bool) {
	return &p2md, true
}

// Preferences preferences related to the order
type Preferences struct {
	// NotificationPreferences - Notification preferences.
	NotificationPreferences *[]NotificationPreference `json:"notificationPreferences,omitempty"`
	// TransportPreferences - Preferences related to the shipment logistics of the order.
	TransportPreferences *TransportPreferences `json:"transportPreferences,omitempty"`
	// EncryptionPreferences - Preferences related to the Encryption.
	EncryptionPreferences *EncryptionPreferences `json:"encryptionPreferences,omitempty"`
	// ManagementResourcePreferences - Preferences related to the Management resource.
	ManagementResourcePreferences *ManagementResourcePreferences `json:"managementResourcePreferences,omitempty"`
}

// Product list of Products
type Product struct {
	// ProductProperties - READ-ONLY; Properties of product
	*ProductProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Product.
func (p Product) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Product struct.
func (p *Product) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var productProperties ProductProperties
				err = json.Unmarshal(*v, &productProperties)
				if err != nil {
					return err
				}
				p.ProductProperties = &productProperties
			}
		}
	}

	return nil
}

// ProductDetails represents product details
type ProductDetails struct {
	// DisplayInfo - Display details of the product
	DisplayInfo *DisplayInfo `json:"displayInfo,omitempty"`
	// HierarchyInformation - Hierarchy of the product which uniquely identifies the product
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty"`
	// Count - Quantity of the product
	Count *int32 `json:"count,omitempty"`
	// DeviceDetails - READ-ONLY; list of device details
	DeviceDetails *[]DeviceDetails `json:"deviceDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductDetails.
func (pd ProductDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pd.DisplayInfo != nil {
		objectMap["displayInfo"] = pd.DisplayInfo
	}
	if pd.HierarchyInformation != nil {
		objectMap["hierarchyInformation"] = pd.HierarchyInformation
	}
	if pd.Count != nil {
		objectMap["count"] = pd.Count
	}
	return json.Marshal(objectMap)
}

// ProductFamilies the list of product families.
type ProductFamilies struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of product families.
	Value *[]ProductFamily `json:"value,omitempty"`
	// NextLink - Link for the next set of product families.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductFamilies.
func (pf ProductFamilies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pf.NextLink != nil {
		objectMap["nextLink"] = pf.NextLink
	}
	return json.Marshal(objectMap)
}

// ProductFamiliesIterator provides access to a complete listing of ProductFamily values.
type ProductFamiliesIterator struct {
	i    int
	page ProductFamiliesPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProductFamiliesIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductFamiliesIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProductFamiliesIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProductFamiliesIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProductFamiliesIterator) Response() ProductFamilies {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProductFamiliesIterator) Value() ProductFamily {
	if !iter.page.NotDone() {
		return ProductFamily{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProductFamiliesIterator type.
func NewProductFamiliesIterator(page ProductFamiliesPage) ProductFamiliesIterator {
	return ProductFamiliesIterator{page: page}
}

// ProductFamiliesMetadata holds details about product family metadata
type ProductFamiliesMetadata struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of product family metadata details.
	Value *[]ProductFamiliesMetadataDetails `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link for the next set of product families.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductFamiliesMetadata.
func (pfm ProductFamiliesMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ProductFamiliesMetadataDetails product families metadata details.
type ProductFamiliesMetadataDetails struct {
	// ProductFamilyProperties - READ-ONLY; Product family properties
	*ProductFamilyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductFamiliesMetadataDetails.
func (pfmd ProductFamiliesMetadataDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProductFamiliesMetadataDetails struct.
func (pfmd *ProductFamiliesMetadataDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var productFamilyProperties ProductFamilyProperties
				err = json.Unmarshal(*v, &productFamilyProperties)
				if err != nil {
					return err
				}
				pfmd.ProductFamilyProperties = &productFamilyProperties
			}
		}
	}

	return nil
}

// ProductFamiliesMetadataIterator provides access to a complete listing of ProductFamiliesMetadataDetails
// values.
type ProductFamiliesMetadataIterator struct {
	i    int
	page ProductFamiliesMetadataPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProductFamiliesMetadataIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductFamiliesMetadataIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProductFamiliesMetadataIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProductFamiliesMetadataIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProductFamiliesMetadataIterator) Response() ProductFamiliesMetadata {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProductFamiliesMetadataIterator) Value() ProductFamiliesMetadataDetails {
	if !iter.page.NotDone() {
		return ProductFamiliesMetadataDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProductFamiliesMetadataIterator type.
func NewProductFamiliesMetadataIterator(page ProductFamiliesMetadataPage) ProductFamiliesMetadataIterator {
	return ProductFamiliesMetadataIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pfm ProductFamiliesMetadata) IsEmpty() bool {
	return pfm.Value == nil || len(*pfm.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pfm ProductFamiliesMetadata) hasNextLink() bool {
	return pfm.NextLink != nil && len(*pfm.NextLink) != 0
}

// productFamiliesMetadataPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pfm ProductFamiliesMetadata) productFamiliesMetadataPreparer(ctx context.Context) (*http.Request, error) {
	if !pfm.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pfm.NextLink)))
}

// ProductFamiliesMetadataPage contains a page of ProductFamiliesMetadataDetails values.
type ProductFamiliesMetadataPage struct {
	fn  func(context.Context, ProductFamiliesMetadata) (ProductFamiliesMetadata, error)
	pfm ProductFamiliesMetadata
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProductFamiliesMetadataPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductFamiliesMetadataPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pfm)
		if err != nil {
			return err
		}
		page.pfm = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProductFamiliesMetadataPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProductFamiliesMetadataPage) NotDone() bool {
	return !page.pfm.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProductFamiliesMetadataPage) Response() ProductFamiliesMetadata {
	return page.pfm
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProductFamiliesMetadataPage) Values() []ProductFamiliesMetadataDetails {
	if page.pfm.IsEmpty() {
		return nil
	}
	return *page.pfm.Value
}

// Creates a new instance of the ProductFamiliesMetadataPage type.
func NewProductFamiliesMetadataPage(cur ProductFamiliesMetadata, getNextPage func(context.Context, ProductFamiliesMetadata) (ProductFamiliesMetadata, error)) ProductFamiliesMetadataPage {
	return ProductFamiliesMetadataPage{
		fn:  getNextPage,
		pfm: cur,
	}
}

// IsEmpty returns true if the ListResult contains no values.
func (pf ProductFamilies) IsEmpty() bool {
	return pf.Value == nil || len(*pf.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pf ProductFamilies) hasNextLink() bool {
	return pf.NextLink != nil && len(*pf.NextLink) != 0
}

// productFamiliesPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pf ProductFamilies) productFamiliesPreparer(ctx context.Context) (*http.Request, error) {
	if !pf.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pf.NextLink)))
}

// ProductFamiliesPage contains a page of ProductFamily values.
type ProductFamiliesPage struct {
	fn func(context.Context, ProductFamilies) (ProductFamilies, error)
	pf ProductFamilies
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProductFamiliesPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductFamiliesPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pf)
		if err != nil {
			return err
		}
		page.pf = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProductFamiliesPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProductFamiliesPage) NotDone() bool {
	return !page.pf.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProductFamiliesPage) Response() ProductFamilies {
	return page.pf
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProductFamiliesPage) Values() []ProductFamily {
	if page.pf.IsEmpty() {
		return nil
	}
	return *page.pf.Value
}

// Creates a new instance of the ProductFamiliesPage type.
func NewProductFamiliesPage(cur ProductFamilies, getNextPage func(context.Context, ProductFamilies) (ProductFamilies, error)) ProductFamiliesPage {
	return ProductFamiliesPage{
		fn: getNextPage,
		pf: cur,
	}
}

// ProductFamiliesRequest the filters for showing the product families.
type ProductFamiliesRequest struct {
	// FilterableProperties - Dictionary of filterable properties on product family.
	FilterableProperties map[string][]FilterableProperty `json:"filterableProperties"`
	// CustomerSubscriptionDetails - Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details
	CustomerSubscriptionDetails *CustomerSubscriptionDetails `json:"customerSubscriptionDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductFamiliesRequest.
func (pfr ProductFamiliesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pfr.FilterableProperties != nil {
		objectMap["filterableProperties"] = pfr.FilterableProperties
	}
	if pfr.CustomerSubscriptionDetails != nil {
		objectMap["customerSubscriptionDetails"] = pfr.CustomerSubscriptionDetails
	}
	return json.Marshal(objectMap)
}

// ProductFamily product Family
type ProductFamily struct {
	// ProductFamilyProperties - READ-ONLY; Properties of product family
	*ProductFamilyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductFamily.
func (pf ProductFamily) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProductFamily struct.
func (pf *ProductFamily) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var productFamilyProperties ProductFamilyProperties
				err = json.Unmarshal(*v, &productFamilyProperties)
				if err != nil {
					return err
				}
				pf.ProductFamilyProperties = &productFamilyProperties
			}
		}
	}

	return nil
}

// ProductFamilyProperties properties of product family
type ProductFamilyProperties struct {
	// ProductLines - READ-ONLY; List of product lines supported in the product family
	ProductLines *[]ProductLine `json:"productLines,omitempty"`
	// FilterableProperties - READ-ONLY; list of filters supported for a product
	FilterableProperties *[]FilterableProperty `json:"filterableProperties,omitempty"`
	// DisplayName - READ-ONLY; Display Name for the product system.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; Description related to the product system.
	Description *Description `json:"description,omitempty"`
	// ImageInformation - READ-ONLY; Image information for the product system.
	ImageInformation *[]ImageInformation `json:"imageInformation,omitempty"`
	// CostInformation - READ-ONLY; Cost information for the product system.
	CostInformation *CostInformation `json:"costInformation,omitempty"`
	// AvailabilityInformation - READ-ONLY; Availability information of the product system.
	AvailabilityInformation *AvailabilityInformation `json:"availabilityInformation,omitempty"`
	// HierarchyInformation - READ-ONLY; Hierarchy information of a product.
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductFamilyProperties.
func (pfp ProductFamilyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ProductLine product line
type ProductLine struct {
	// ProductLineProperties - READ-ONLY; Properties of product line
	*ProductLineProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductLine.
func (pl ProductLine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProductLine struct.
func (pl *ProductLine) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var productLineProperties ProductLineProperties
				err = json.Unmarshal(*v, &productLineProperties)
				if err != nil {
					return err
				}
				pl.ProductLineProperties = &productLineProperties
			}
		}
	}

	return nil
}

// ProductLineProperties properties of product line
type ProductLineProperties struct {
	// Products - READ-ONLY; List of products in the product line
	Products *[]Product `json:"products,omitempty"`
	// FilterableProperties - READ-ONLY; list of filters supported for a product
	FilterableProperties *[]FilterableProperty `json:"filterableProperties,omitempty"`
	// DisplayName - READ-ONLY; Display Name for the product system.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; Description related to the product system.
	Description *Description `json:"description,omitempty"`
	// ImageInformation - READ-ONLY; Image information for the product system.
	ImageInformation *[]ImageInformation `json:"imageInformation,omitempty"`
	// CostInformation - READ-ONLY; Cost information for the product system.
	CostInformation *CostInformation `json:"costInformation,omitempty"`
	// AvailabilityInformation - READ-ONLY; Availability information of the product system.
	AvailabilityInformation *AvailabilityInformation `json:"availabilityInformation,omitempty"`
	// HierarchyInformation - READ-ONLY; Hierarchy information of a product.
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductLineProperties.
func (plp ProductLineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ProductProperties properties of products
type ProductProperties struct {
	// Configurations - READ-ONLY; List of configurations for the product
	Configurations *[]Configuration `json:"configurations,omitempty"`
	// FilterableProperties - READ-ONLY; list of filters supported for a product
	FilterableProperties *[]FilterableProperty `json:"filterableProperties,omitempty"`
	// DisplayName - READ-ONLY; Display Name for the product system.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; Description related to the product system.
	Description *Description `json:"description,omitempty"`
	// ImageInformation - READ-ONLY; Image information for the product system.
	ImageInformation *[]ImageInformation `json:"imageInformation,omitempty"`
	// CostInformation - READ-ONLY; Cost information for the product system.
	CostInformation *CostInformation `json:"costInformation,omitempty"`
	// AvailabilityInformation - READ-ONLY; Availability information of the product system.
	AvailabilityInformation *AvailabilityInformation `json:"availabilityInformation,omitempty"`
	// HierarchyInformation - READ-ONLY; Hierarchy information of a product.
	HierarchyInformation *HierarchyInformation `json:"hierarchyInformation,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductProperties.
func (pp ProductProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PurchaseMeterDetails billing type Purchase meter details
type PurchaseMeterDetails struct {
	// ProductID - READ-ONLY; Product Id
	ProductID *string `json:"productId,omitempty"`
	// SkuID - READ-ONLY; Sku Id
	SkuID *string `json:"skuId,omitempty"`
	// TermID - READ-ONLY; Term Id
	TermID *string `json:"termId,omitempty"`
	// Multiplier - READ-ONLY; Billing unit applicable for Pav2 billing
	Multiplier *float64 `json:"multiplier,omitempty"`
	// ChargingType - READ-ONLY; Charging type. Possible values include: 'ChargingTypePerOrder', 'ChargingTypePerDevice'
	ChargingType ChargingType `json:"chargingType,omitempty"`
	// BillingType - Possible values include: 'BillingTypeMeterDetails', 'BillingTypePav2', 'BillingTypePurchase'
	BillingType BillingType `json:"billingType,omitempty"`
}

// MarshalJSON is the custom marshaler for PurchaseMeterDetails.
func (pmd PurchaseMeterDetails) MarshalJSON() ([]byte, error) {
	pmd.BillingType = BillingTypePurchase
	objectMap := make(map[string]interface{})
	if pmd.BillingType != "" {
		objectMap["billingType"] = pmd.BillingType
	}
	return json.Marshal(objectMap)
}

// AsPav2MeterDetails is the BasicMeterDetails implementation for PurchaseMeterDetails.
func (pmd PurchaseMeterDetails) AsPav2MeterDetails() (*Pav2MeterDetails, bool) {
	return nil, false
}

// AsPurchaseMeterDetails is the BasicMeterDetails implementation for PurchaseMeterDetails.
func (pmd PurchaseMeterDetails) AsPurchaseMeterDetails() (*PurchaseMeterDetails, bool) {
	return &pmd, true
}

// AsMeterDetails is the BasicMeterDetails implementation for PurchaseMeterDetails.
func (pmd PurchaseMeterDetails) AsMeterDetails() (*MeterDetails, bool) {
	return nil, false
}

// AsBasicMeterDetails is the BasicMeterDetails implementation for PurchaseMeterDetails.
func (pmd PurchaseMeterDetails) AsBasicMeterDetails() (BasicMeterDetails, bool) {
	return &pmd, true
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceIdentity msi identity details of the resource
type ResourceIdentity struct {
	// Type - Identity type
	Type *string `json:"type,omitempty"`
	// PrincipalID - READ-ONLY; Service Principal Id backing the Msi
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; Home Tenant Id
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceIdentity.
func (ri ResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ri.Type != nil {
		objectMap["type"] = ri.Type
	}
	return json.Marshal(objectMap)
}

// ReturnOrderItemDetails return order item request body
type ReturnOrderItemDetails struct {
	// ReturnAddress - customer return address.
	ReturnAddress *AddressProperties `json:"returnAddress,omitempty"`
	// ReturnReason - Return Reason.
	ReturnReason *string `json:"returnReason,omitempty"`
}

// ReturnOrderItemFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReturnOrderItemFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BaseClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReturnOrderItemFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReturnOrderItemFuture.Result.
func (future *ReturnOrderItemFuture) result(client BaseClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.ReturnOrderItemFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("edgeorder.ReturnOrderItemFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ShippingAddress shipping address where customer wishes to receive the device.
type ShippingAddress struct {
	// StreetAddress1 - Street Address line 1.
	StreetAddress1 *string `json:"streetAddress1,omitempty"`
	// StreetAddress2 - Street Address line 2.
	StreetAddress2 *string `json:"streetAddress2,omitempty"`
	// StreetAddress3 - Street Address line 3.
	StreetAddress3 *string `json:"streetAddress3,omitempty"`
	// City - Name of the City.
	City *string `json:"city,omitempty"`
	// StateOrProvince - Name of the State or Province.
	StateOrProvince *string `json:"stateOrProvince,omitempty"`
	// Country - Name of the Country.
	Country *string `json:"country,omitempty"`
	// PostalCode - Postal code.
	PostalCode *string `json:"postalCode,omitempty"`
	// ZipExtendedCode - Extended Zip Code.
	ZipExtendedCode *string `json:"zipExtendedCode,omitempty"`
	// CompanyName - Name of the company.
	CompanyName *string `json:"companyName,omitempty"`
	// AddressType - Type of address. Possible values include: 'AddressTypeNone', 'AddressTypeResidential', 'AddressTypeCommercial'
	AddressType AddressType `json:"addressType,omitempty"`
}

// ShippingDetails package shipping details
type ShippingDetails struct {
	// CarrierName - READ-ONLY; Name of the carrier.
	CarrierName *string `json:"carrierName,omitempty"`
	// CarrierDisplayName - READ-ONLY; Carrier Name for display purpose. Not to be used for any processing.
	CarrierDisplayName *string `json:"carrierDisplayName,omitempty"`
	// TrackingID - READ-ONLY; TrackingId of the package
	TrackingID *string `json:"trackingId,omitempty"`
	// TrackingURL - READ-ONLY; TrackingUrl of the package.
	TrackingURL *string `json:"trackingUrl,omitempty"`
}

// MarshalJSON is the custom marshaler for ShippingDetails.
func (sd ShippingDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Specification specifications of the configurations
type Specification struct {
	// Name - READ-ONLY; Name of the specification
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; Value of the specification
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for Specification.
func (s Specification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// StageDetails resource stage details.
type StageDetails struct {
	// StageStatus - READ-ONLY; Stage status. Possible values include: 'StageStatusNone', 'StageStatusInProgress', 'StageStatusSucceeded', 'StageStatusFailed', 'StageStatusCancelled', 'StageStatusCancelling'
	StageStatus StageStatus `json:"stageStatus,omitempty"`
	// StageName - READ-ONLY; Stage name. Possible values include: 'StageNamePlaced', 'StageNameInReview', 'StageNameConfirmed', 'StageNameReadyToShip', 'StageNameShipped', 'StageNameDelivered', 'StageNameInUse', 'StageNameReturnInitiated', 'StageNameReturnPickedUp', 'StageNameReturnedToMicrosoft', 'StageNameReturnCompleted', 'StageNameCancelled'
	StageName StageName `json:"stageName,omitempty"`
	// DisplayName - READ-ONLY; Display name of the resource stage.
	DisplayName *string `json:"displayName,omitempty"`
	// StartTime - READ-ONLY; Stage start time
	StartTime *date.Time `json:"startTime,omitempty"`
}

// MarshalJSON is the custom marshaler for StageDetails.
func (sd StageDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// TransportPreferences preferences related to the shipment logistics of the sku
type TransportPreferences struct {
	// PreferredShipmentType - Indicates Shipment Logistics type that the customer preferred. Possible values include: 'TransportShipmentTypesCustomerManaged', 'TransportShipmentTypesMicrosoftManaged'
	PreferredShipmentType TransportShipmentTypes `json:"preferredShipmentType,omitempty"`
}

// UpdateAddressFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type UpdateAddressFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BaseClient) (AddressResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UpdateAddressFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UpdateAddressFuture.Result.
func (future *UpdateAddressFuture) result(client BaseClient) (ar AddressResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.UpdateAddressFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("edgeorder.UpdateAddressFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ar.Response.Response, err = future.GetResult(sender); err == nil && ar.Response.Response.StatusCode != http.StatusNoContent {
		ar, err = client.UpdateAddressResponder(ar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "edgeorder.UpdateAddressFuture", "Result", ar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// UpdateOrderItemFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type UpdateOrderItemFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(BaseClient) (OrderItemResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UpdateOrderItemFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UpdateOrderItemFuture.Result.
func (future *UpdateOrderItemFuture) result(client BaseClient) (oir OrderItemResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.UpdateOrderItemFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		oir.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("edgeorder.UpdateOrderItemFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if oir.Response.Response, err = future.GetResult(sender); err == nil && oir.Response.Response.StatusCode != http.StatusNoContent {
		oir, err = client.UpdateOrderItemResponder(oir.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "edgeorder.UpdateOrderItemFuture", "Result", oir.Response.Response, "Failure responding to request")
		}
	}
	return
}
