// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/template/edge/template_handler_service.proto

/*
	Package edge is a generated protocol buffer package.

	The `edge` template represents an edge in the mesh graph.

	The `edge` template represents an edge in the mesh graph

	When writing the configuration, the value for the fields associated
	with this template can either be a literal or an
	[expression](https://istio.io/docs/reference/config/policy-and-telemetry/expression-language/). Please
	note that if the datatype of a field is not
	istio.mixer.adapter.model.v1beta1.Value, then the expression's
	[inferred type](https://istio.io/docs/reference/config/policy-and-telemetry/expression-language/#type-checking)
	must match the datatype of the field.

	Example config:
	```yaml
	apiVersion: "config.istio.io/v1alpha2"
	kind: edge
	metadata:
	  name: default
	  namespace: istio-system
	spec:
	  timestamp: request.time
	  sourceUid: source.uid | "Unknown"
	  sourceOwner: source.owner | "Unknown"
	  sourceWorkloadName: source.workload.name | "Unknown"
	  sourceWorkloadNamespace: source.workload.namespace | "Unknown"
	  destinationUid: destination.uid | "Unknown"
	  destinationOwner: destination.owner | "Unknown"
	  destinationWorkloadName: destination.workload.name | "Unknown"
	  destinationWorkloadNamespace: destination.workload.namespace | "Unknown"
	  destinationServiceName: destination.service.name | "Unknown"
	  destinationServiceNamespace: destination.service.namespace | "Unknown"
	  apiProtocol: api.protocol | "Unknown"
	  contextProtocol: context.protocol | "Unknown"
	```

	It is generated from these files:
		mixer/template/edge/template_handler_service.proto

	It has these top-level messages:
		HandleEdgeRequest
		InstanceMsg
		Type
		InstanceParam
*/
package edge

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "istio.io/api/mixer/adapter/model/v1beta1"
import google_protobuf1 "github.com/gogo/protobuf/types"
import istio_mixer_adapter_model_v1beta11 "istio.io/api/mixer/adapter/model/v1beta1"
import istio_policy_v1beta1 "istio.io/api/policy/v1beta1"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Request message for HandleEdge method.
type HandleEdgeRequest struct {
	// 'edge' instances.
	Instances []*InstanceMsg `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty"`
	// Adapter specific handler configuration.
	//
	// Note: Backends can also implement [InfrastructureBackend][https://istio.io/docs/reference/config/mixer/istio.mixer.adapter.model.v1beta1.html#InfrastructureBackend]
	// service and therefore opt to receive handler configuration during session creation through [InfrastructureBackend.CreateSession][TODO: Link to this fragment]
	// call. In that case, adapter_config will have type_url as 'google.protobuf.Any.type_url' and would contain string
	// value of session_id (returned from InfrastructureBackend.CreateSession).
	AdapterConfig *google_protobuf1.Any `protobuf:"bytes,2,opt,name=adapter_config,json=adapterConfig" json:"adapter_config,omitempty"`
	// Id to dedupe identical requests from Mixer.
	DedupId string `protobuf:"bytes,3,opt,name=dedup_id,json=dedupId,proto3" json:"dedup_id,omitempty"`
}

func (m *HandleEdgeRequest) Reset()      { *m = HandleEdgeRequest{} }
func (*HandleEdgeRequest) ProtoMessage() {}
func (*HandleEdgeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptorTemplateHandlerService, []int{0}
}

// Contains instance payload for 'edge' template. This is passed to infrastructure backends during request-time
// through HandleEdgeService.HandleEdge.
type InstanceMsg struct {
	// Name of the instance as specified in configuration.
	Name string `protobuf:"bytes,72295727,opt,name=name,proto3" json:"name,omitempty"`
	// Timestamp of the edge
	Timestamp *istio_policy_v1beta1.TimeStamp `protobuf:"bytes,1,opt,name=timestamp" json:"timestamp,omitempty"`
	// Namespace of the source workload
	SourceWorkloadNamespace string `protobuf:"bytes,10,opt,name=source_workload_namespace,json=sourceWorkloadNamespace,proto3" json:"source_workload_namespace,omitempty"`
	// Name of the source workload
	SourceWorkloadName string `protobuf:"bytes,11,opt,name=source_workload_name,json=sourceWorkloadName,proto3" json:"source_workload_name,omitempty"`
	// Owner of the source workload (often k8s deployment)
	SourceOwner string `protobuf:"bytes,12,opt,name=source_owner,json=sourceOwner,proto3" json:"source_owner,omitempty"`
	// UID of the source workload
	SourceUid string `protobuf:"bytes,13,opt,name=source_uid,json=sourceUid,proto3" json:"source_uid,omitempty"`
	// Namespace of the destination workload
	DestinationWorkloadNamespace string `protobuf:"bytes,20,opt,name=destination_workload_namespace,json=destinationWorkloadNamespace,proto3" json:"destination_workload_namespace,omitempty"`
	// Name of the destination workload
	DestinationWorkloadName string `protobuf:"bytes,21,opt,name=destination_workload_name,json=destinationWorkloadName,proto3" json:"destination_workload_name,omitempty"`
	// Owner of the destination workload (often k8s deployment)
	DestinationOwner string `protobuf:"bytes,22,opt,name=destination_owner,json=destinationOwner,proto3" json:"destination_owner,omitempty"`
	// UID of the destination workload
	DestinationUid string `protobuf:"bytes,23,opt,name=destination_uid,json=destinationUid,proto3" json:"destination_uid,omitempty"`
	// Namespace of the destination Service
	DestinationServiceNamespace string `protobuf:"bytes,24,opt,name=destination_service_namespace,json=destinationServiceNamespace,proto3" json:"destination_service_namespace,omitempty"`
	// Name of the destination Service
	DestinationServiceName string `protobuf:"bytes,25,opt,name=destination_service_name,json=destinationServiceName,proto3" json:"destination_service_name,omitempty"`
	// Protocol used for communication (http, tcp)
	ContextProtocol string `protobuf:"bytes,30,opt,name=context_protocol,json=contextProtocol,proto3" json:"context_protocol,omitempty"`
	// The protocol type of the API call (http, https, grpc)
	ApiProtocol string `protobuf:"bytes,31,opt,name=api_protocol,json=apiProtocol,proto3" json:"api_protocol,omitempty"`
}

func (m *InstanceMsg) Reset()      { *m = InstanceMsg{} }
func (*InstanceMsg) ProtoMessage() {}
func (*InstanceMsg) Descriptor() ([]byte, []int) {
	return fileDescriptorTemplateHandlerService, []int{1}
}

// Contains inferred type information about specific instance of 'edge' template. This is passed to
// infrastructure backends during configuration-time through [InfrastructureBackend.CreateSession][TODO: Link to this fragment].
type Type struct {
}

func (m *Type) Reset()                    { *m = Type{} }
func (*Type) ProtoMessage()               {}
func (*Type) Descriptor() ([]byte, []int) { return fileDescriptorTemplateHandlerService, []int{2} }

// Represents instance configuration schema for 'edge' template.
type InstanceParam struct {
	// Timestamp of the edge
	Timestamp string `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Namespace of the source workload
	SourceWorkloadNamespace string `protobuf:"bytes,10,opt,name=source_workload_namespace,json=sourceWorkloadNamespace,proto3" json:"source_workload_namespace,omitempty"`
	// Name of the source workload
	SourceWorkloadName string `protobuf:"bytes,11,opt,name=source_workload_name,json=sourceWorkloadName,proto3" json:"source_workload_name,omitempty"`
	// Owner of the source workload (often k8s deployment)
	SourceOwner string `protobuf:"bytes,12,opt,name=source_owner,json=sourceOwner,proto3" json:"source_owner,omitempty"`
	// UID of the source workload
	SourceUid string `protobuf:"bytes,13,opt,name=source_uid,json=sourceUid,proto3" json:"source_uid,omitempty"`
	// Namespace of the destination workload
	DestinationWorkloadNamespace string `protobuf:"bytes,20,opt,name=destination_workload_namespace,json=destinationWorkloadNamespace,proto3" json:"destination_workload_namespace,omitempty"`
	// Name of the destination workload
	DestinationWorkloadName string `protobuf:"bytes,21,opt,name=destination_workload_name,json=destinationWorkloadName,proto3" json:"destination_workload_name,omitempty"`
	// Owner of the destination workload (often k8s deployment)
	DestinationOwner string `protobuf:"bytes,22,opt,name=destination_owner,json=destinationOwner,proto3" json:"destination_owner,omitempty"`
	// UID of the destination workload
	DestinationUid string `protobuf:"bytes,23,opt,name=destination_uid,json=destinationUid,proto3" json:"destination_uid,omitempty"`
	// Namespace of the destination Service
	DestinationServiceNamespace string `protobuf:"bytes,24,opt,name=destination_service_namespace,json=destinationServiceNamespace,proto3" json:"destination_service_namespace,omitempty"`
	// Name of the destination Service
	DestinationServiceName string `protobuf:"bytes,25,opt,name=destination_service_name,json=destinationServiceName,proto3" json:"destination_service_name,omitempty"`
	// Protocol used for communication (http, tcp)
	ContextProtocol string `protobuf:"bytes,30,opt,name=context_protocol,json=contextProtocol,proto3" json:"context_protocol,omitempty"`
	// The protocol type of the API call (http, https, grpc)
	ApiProtocol string `protobuf:"bytes,31,opt,name=api_protocol,json=apiProtocol,proto3" json:"api_protocol,omitempty"`
}

func (m *InstanceParam) Reset()      { *m = InstanceParam{} }
func (*InstanceParam) ProtoMessage() {}
func (*InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptorTemplateHandlerService, []int{3}
}

func init() {
	proto.RegisterType((*HandleEdgeRequest)(nil), "edge.HandleEdgeRequest")
	proto.RegisterType((*InstanceMsg)(nil), "edge.InstanceMsg")
	proto.RegisterType((*Type)(nil), "edge.Type")
	proto.RegisterType((*InstanceParam)(nil), "edge.InstanceParam")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for HandleEdgeService service

type HandleEdgeServiceClient interface {
	// HandleEdge is called by Mixer at request-time to deliver 'edge' instances to the backend.
	HandleEdge(ctx context.Context, in *HandleEdgeRequest, opts ...grpc.CallOption) (*istio_mixer_adapter_model_v1beta11.ReportResult, error)
}

type handleEdgeServiceClient struct {
	cc *grpc.ClientConn
}

func NewHandleEdgeServiceClient(cc *grpc.ClientConn) HandleEdgeServiceClient {
	return &handleEdgeServiceClient{cc}
}

func (c *handleEdgeServiceClient) HandleEdge(ctx context.Context, in *HandleEdgeRequest, opts ...grpc.CallOption) (*istio_mixer_adapter_model_v1beta11.ReportResult, error) {
	out := new(istio_mixer_adapter_model_v1beta11.ReportResult)
	err := grpc.Invoke(ctx, "/edge.HandleEdgeService/HandleEdge", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for HandleEdgeService service

type HandleEdgeServiceServer interface {
	// HandleEdge is called by Mixer at request-time to deliver 'edge' instances to the backend.
	HandleEdge(context.Context, *HandleEdgeRequest) (*istio_mixer_adapter_model_v1beta11.ReportResult, error)
}

func RegisterHandleEdgeServiceServer(s *grpc.Server, srv HandleEdgeServiceServer) {
	s.RegisterService(&_HandleEdgeService_serviceDesc, srv)
}

func _HandleEdgeService_HandleEdge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleEdgeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HandleEdgeServiceServer).HandleEdge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/edge.HandleEdgeService/HandleEdge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HandleEdgeServiceServer).HandleEdge(ctx, req.(*HandleEdgeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HandleEdgeService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "edge.HandleEdgeService",
	HandlerType: (*HandleEdgeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleEdge",
			Handler:    _HandleEdgeService_HandleEdge_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/template/edge/template_handler_service.proto",
}

func (m *HandleEdgeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandleEdgeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, msg := range m.Instances {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AdapterConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.AdapterConfig.Size()))
		n1, err := m.AdapterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.DedupId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DedupId)))
		i += copy(dAtA[i:], m.DedupId)
	}
	return i, nil
}

func (m *InstanceMsg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceMsg) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timestamp != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.Timestamp.Size()))
		n2, err := m.Timestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.SourceWorkloadNamespace) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadNamespace)))
		i += copy(dAtA[i:], m.SourceWorkloadNamespace)
	}
	if len(m.SourceWorkloadName) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadName)))
		i += copy(dAtA[i:], m.SourceWorkloadName)
	}
	if len(m.SourceOwner) > 0 {
		dAtA[i] = 0x62
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceOwner)))
		i += copy(dAtA[i:], m.SourceOwner)
	}
	if len(m.SourceUid) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceUid)))
		i += copy(dAtA[i:], m.SourceUid)
	}
	if len(m.DestinationWorkloadNamespace) > 0 {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadNamespace)))
		i += copy(dAtA[i:], m.DestinationWorkloadNamespace)
	}
	if len(m.DestinationWorkloadName) > 0 {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadName)))
		i += copy(dAtA[i:], m.DestinationWorkloadName)
	}
	if len(m.DestinationOwner) > 0 {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationOwner)))
		i += copy(dAtA[i:], m.DestinationOwner)
	}
	if len(m.DestinationUid) > 0 {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationUid)))
		i += copy(dAtA[i:], m.DestinationUid)
	}
	if len(m.DestinationServiceNamespace) > 0 {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationServiceNamespace)))
		i += copy(dAtA[i:], m.DestinationServiceNamespace)
	}
	if len(m.DestinationServiceName) > 0 {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationServiceName)))
		i += copy(dAtA[i:], m.DestinationServiceName)
	}
	if len(m.ContextProtocol) > 0 {
		dAtA[i] = 0xf2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ContextProtocol)))
		i += copy(dAtA[i:], m.ContextProtocol)
	}
	if len(m.ApiProtocol) > 0 {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiProtocol)))
		i += copy(dAtA[i:], m.ApiProtocol)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0xe4
		i++
		dAtA[i] = 0x93
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Timestamp) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Timestamp)))
		i += copy(dAtA[i:], m.Timestamp)
	}
	if len(m.SourceWorkloadNamespace) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadNamespace)))
		i += copy(dAtA[i:], m.SourceWorkloadNamespace)
	}
	if len(m.SourceWorkloadName) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadName)))
		i += copy(dAtA[i:], m.SourceWorkloadName)
	}
	if len(m.SourceOwner) > 0 {
		dAtA[i] = 0x62
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceOwner)))
		i += copy(dAtA[i:], m.SourceOwner)
	}
	if len(m.SourceUid) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceUid)))
		i += copy(dAtA[i:], m.SourceUid)
	}
	if len(m.DestinationWorkloadNamespace) > 0 {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadNamespace)))
		i += copy(dAtA[i:], m.DestinationWorkloadNamespace)
	}
	if len(m.DestinationWorkloadName) > 0 {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadName)))
		i += copy(dAtA[i:], m.DestinationWorkloadName)
	}
	if len(m.DestinationOwner) > 0 {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationOwner)))
		i += copy(dAtA[i:], m.DestinationOwner)
	}
	if len(m.DestinationUid) > 0 {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationUid)))
		i += copy(dAtA[i:], m.DestinationUid)
	}
	if len(m.DestinationServiceNamespace) > 0 {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationServiceNamespace)))
		i += copy(dAtA[i:], m.DestinationServiceNamespace)
	}
	if len(m.DestinationServiceName) > 0 {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationServiceName)))
		i += copy(dAtA[i:], m.DestinationServiceName)
	}
	if len(m.ContextProtocol) > 0 {
		dAtA[i] = 0xf2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ContextProtocol)))
		i += copy(dAtA[i:], m.ContextProtocol)
	}
	if len(m.ApiProtocol) > 0 {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiProtocol)))
		i += copy(dAtA[i:], m.ApiProtocol)
	}
	return i, nil
}

func encodeVarintTemplateHandlerService(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *HandleEdgeRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, e := range m.Instances {
			l = e.Size()
			n += 1 + l + sovTemplateHandlerService(uint64(l))
		}
	}
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DedupId)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *InstanceMsg) Size() (n int) {
	var l int
	_ = l
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadNamespace)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadName)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceOwner)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceUid)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadNamespace)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadName)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationOwner)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationUid)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationServiceNamespace)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationServiceName)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ContextProtocol)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiProtocol)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 5 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *Type) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *InstanceParam) Size() (n int) {
	var l int
	_ = l
	l = len(m.Timestamp)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadNamespace)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadName)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceOwner)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceUid)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadNamespace)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadName)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationOwner)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationUid)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationServiceNamespace)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationServiceName)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ContextProtocol)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiProtocol)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func sovTemplateHandlerService(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTemplateHandlerService(x uint64) (n int) {
	return sovTemplateHandlerService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HandleEdgeRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HandleEdgeRequest{`,
		`Instances:` + strings.Replace(fmt.Sprintf("%v", this.Instances), "InstanceMsg", "InstanceMsg", 1) + `,`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "google_protobuf1.Any", 1) + `,`,
		`DedupId:` + fmt.Sprintf("%v", this.DedupId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceMsg) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InstanceMsg{`,
		`Timestamp:` + strings.Replace(fmt.Sprintf("%v", this.Timestamp), "TimeStamp", "istio_policy_v1beta1.TimeStamp", 1) + `,`,
		`SourceWorkloadNamespace:` + fmt.Sprintf("%v", this.SourceWorkloadNamespace) + `,`,
		`SourceWorkloadName:` + fmt.Sprintf("%v", this.SourceWorkloadName) + `,`,
		`SourceOwner:` + fmt.Sprintf("%v", this.SourceOwner) + `,`,
		`SourceUid:` + fmt.Sprintf("%v", this.SourceUid) + `,`,
		`DestinationWorkloadNamespace:` + fmt.Sprintf("%v", this.DestinationWorkloadNamespace) + `,`,
		`DestinationWorkloadName:` + fmt.Sprintf("%v", this.DestinationWorkloadName) + `,`,
		`DestinationOwner:` + fmt.Sprintf("%v", this.DestinationOwner) + `,`,
		`DestinationUid:` + fmt.Sprintf("%v", this.DestinationUid) + `,`,
		`DestinationServiceNamespace:` + fmt.Sprintf("%v", this.DestinationServiceNamespace) + `,`,
		`DestinationServiceName:` + fmt.Sprintf("%v", this.DestinationServiceName) + `,`,
		`ContextProtocol:` + fmt.Sprintf("%v", this.ContextProtocol) + `,`,
		`ApiProtocol:` + fmt.Sprintf("%v", this.ApiProtocol) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Type) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Type{`,
		`}`,
	}, "")
	return s
}
func (this *InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InstanceParam{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`SourceWorkloadNamespace:` + fmt.Sprintf("%v", this.SourceWorkloadNamespace) + `,`,
		`SourceWorkloadName:` + fmt.Sprintf("%v", this.SourceWorkloadName) + `,`,
		`SourceOwner:` + fmt.Sprintf("%v", this.SourceOwner) + `,`,
		`SourceUid:` + fmt.Sprintf("%v", this.SourceUid) + `,`,
		`DestinationWorkloadNamespace:` + fmt.Sprintf("%v", this.DestinationWorkloadNamespace) + `,`,
		`DestinationWorkloadName:` + fmt.Sprintf("%v", this.DestinationWorkloadName) + `,`,
		`DestinationOwner:` + fmt.Sprintf("%v", this.DestinationOwner) + `,`,
		`DestinationUid:` + fmt.Sprintf("%v", this.DestinationUid) + `,`,
		`DestinationServiceNamespace:` + fmt.Sprintf("%v", this.DestinationServiceNamespace) + `,`,
		`DestinationServiceName:` + fmt.Sprintf("%v", this.DestinationServiceName) + `,`,
		`ContextProtocol:` + fmt.Sprintf("%v", this.ContextProtocol) + `,`,
		`ApiProtocol:` + fmt.Sprintf("%v", this.ApiProtocol) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTemplateHandlerService(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HandleEdgeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandleEdgeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandleEdgeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, &InstanceMsg{})
			if err := m.Instances[len(m.Instances)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &google_protobuf1.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DedupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DedupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceMsg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &istio_policy_v1beta1.TimeStamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationServiceNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationServiceNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationServiceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationServiceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContextProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContextProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 72295727:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Timestamp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationServiceNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationServiceNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationServiceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationServiceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContextProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContextProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTemplateHandlerService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTemplateHandlerService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTemplateHandlerService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTemplateHandlerService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTemplateHandlerService   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("mixer/template/edge/template_handler_service.proto", fileDescriptorTemplateHandlerService)
}

var fileDescriptorTemplateHandlerService = []byte{
	// 694 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x55, 0x3d, 0x6f, 0xd4, 0x4c,
	0x10, 0x3e, 0xe7, 0xeb, 0x7d, 0x6f, 0x2f, 0x9f, 0xab, 0x4b, 0xe2, 0xcb, 0x9b, 0x6c, 0xf2, 0x5e,
	0xc3, 0x21, 0x90, 0x4d, 0x8e, 0x06, 0x05, 0x21, 0x41, 0x00, 0x89, 0x14, 0x40, 0xe4, 0x04, 0x28,
	0xad, 0x8d, 0x3d, 0x31, 0xab, 0xd8, 0x5e, 0x63, 0xef, 0x25, 0xb9, 0x0e, 0xf8, 0x05, 0x48, 0x69,
	0xf9, 0x01, 0x74, 0x94, 0x34, 0xfc, 0x80, 0x88, 0x2a, 0xa2, 0xa2, 0x41, 0xe2, 0x4c, 0x0a, 0xca,
	0x94, 0x94, 0xc8, 0xeb, 0xbd, 0x3b, 0x8b, 0x24, 0x74, 0x74, 0xe9, 0x6e, 0x9f, 0x79, 0x9e, 0x99,
	0x79, 0xe4, 0xb9, 0x19, 0xd4, 0x0c, 0xd8, 0x3e, 0xc4, 0xa6, 0x80, 0x20, 0xf2, 0xa9, 0x00, 0x13,
	0x5c, 0x0f, 0x7a, 0x2f, 0xfb, 0x39, 0x0d, 0x5d, 0x1f, 0x62, 0x3b, 0x81, 0x78, 0x97, 0x39, 0x60,
	0x44, 0x31, 0x17, 0x1c, 0x0f, 0x65, 0xa4, 0xb9, 0xaa, 0xc7, 0x3d, 0x2e, 0x01, 0x33, 0xfb, 0x95,
	0xc7, 0xe6, 0xae, 0xe6, 0xf9, 0xa8, 0x4b, 0x23, 0x01, 0xb1, 0x19, 0x70, 0x17, 0x7c, 0x73, 0x77,
	0x79, 0x0b, 0x04, 0x5d, 0x36, 0x61, 0x5f, 0x40, 0x98, 0x30, 0x1e, 0x26, 0x8a, 0x5d, 0xf3, 0x38,
	0xf7, 0x7c, 0x30, 0xe5, 0x6b, 0xab, 0xb5, 0x6d, 0xd2, 0xb0, 0xad, 0x42, 0x8d, 0x3f, 0x25, 0x8a,
	0x21, 0xe2, 0xb1, 0xe8, 0x26, 0x89, 0xb8, 0xcf, 0x9c, 0x76, 0x2f, 0x28, 0xda, 0x91, 0xea, 0xb4,
	0xfe, 0x56, 0x43, 0x53, 0x0f, 0xa4, 0x87, 0xfb, 0xae, 0x07, 0x16, 0xbc, 0x68, 0x41, 0x22, 0xb0,
	0x89, 0xca, 0x2c, 0x4c, 0x04, 0x0d, 0x1d, 0x48, 0x74, 0x6d, 0x69, 0xb0, 0x51, 0x69, 0x4e, 0x19,
	0x99, 0x27, 0x63, 0x4d, 0xc1, 0x0f, 0x13, 0xcf, 0xea, 0x73, 0xf0, 0x4d, 0x34, 0xae, 0xfa, 0xb0,
	0x1d, 0x1e, 0x6e, 0x33, 0x4f, 0x1f, 0x58, 0xd2, 0x1a, 0x95, 0x66, 0xd5, 0xc8, 0xfb, 0x37, 0xba,
	0xfd, 0x1b, 0x77, 0xc2, 0xb6, 0x35, 0xa6, 0xb8, 0x77, 0x25, 0x15, 0xd7, 0xd0, 0xbf, 0x2e, 0xb8,
	0xad, 0xc8, 0x66, 0xae, 0x3e, 0xb8, 0xa4, 0x35, 0xca, 0xd6, 0x3f, 0xf2, 0xbd, 0xe6, 0xd6, 0x3f,
	0x0c, 0xa3, 0x4a, 0xa1, 0x24, 0xbe, 0x85, 0xca, 0x82, 0x05, 0x90, 0x08, 0x1a, 0x44, 0xba, 0x26,
	0x4b, 0x2c, 0x1a, 0x2c, 0x11, 0x8c, 0x1b, 0xb9, 0x47, 0x43, 0x79, 0x34, 0x36, 0x59, 0x00, 0x1b,
	0x19, 0xcd, 0xea, 0x2b, 0xf0, 0x0a, 0xaa, 0x25, 0xbc, 0x15, 0x3b, 0x60, 0xef, 0xf1, 0x78, 0xc7,
	0xe7, 0xd4, 0xb5, 0x43, 0x1a, 0x40, 0x12, 0x51, 0x07, 0x74, 0x24, 0x4b, 0xcf, 0xe6, 0x84, 0x67,
	0x2a, 0xfe, 0xa8, 0x1b, 0xc6, 0xd7, 0x50, 0xf5, 0x2c, 0xad, 0x5e, 0x91, 0x32, 0x7c, 0x5a, 0x86,
	0xff, 0x47, 0xa3, 0x4a, 0xc1, 0xf7, 0x42, 0x88, 0xf5, 0x51, 0xc9, 0xac, 0xe4, 0xd8, 0xe3, 0x0c,
	0xc2, 0x0b, 0x08, 0x29, 0x4a, 0x8b, 0xb9, 0xfa, 0x98, 0x24, 0x94, 0x73, 0xe4, 0x09, 0x73, 0xf1,
	0x3d, 0x44, 0x5c, 0x48, 0x04, 0x0b, 0xa9, 0x60, 0x3c, 0x3c, 0xab, 0xe9, 0xaa, 0x94, 0xcc, 0x17,
	0x58, 0xa7, 0x3b, 0x5f, 0x41, 0xb5, 0x73, 0xb3, 0xe8, 0xd3, 0xb9, 0xeb, 0x73, 0x12, 0xe0, 0x2b,
	0x68, 0xaa, 0xa8, 0xcd, 0x8d, 0xcc, 0x48, 0xcd, 0x64, 0x21, 0x90, 0xbb, 0xb9, 0x84, 0x26, 0x8a,
	0xe4, 0xcc, 0xd2, 0xac, 0xa4, 0x8e, 0x17, 0xe0, 0xcc, 0xd7, 0x2a, 0x5a, 0x28, 0x12, 0xd5, 0x9f,
	0xa7, 0x60, 0x4b, 0x97, 0xb2, 0xff, 0x0a, 0xa4, 0x8d, 0x9c, 0xd3, 0x77, 0x75, 0x03, 0xe9, 0xe7,
	0xe5, 0xd0, 0x6b, 0x52, 0x3e, 0x73, 0xb6, 0x1c, 0x5f, 0x46, 0x93, 0x0e, 0x0f, 0x05, 0xec, 0x0b,
	0x5b, 0x8e, 0xa5, 0xc3, 0x7d, 0x9d, 0x48, 0xc5, 0x84, 0xc2, 0xd7, 0x15, 0x9c, 0x7d, 0x42, 0x1a,
	0xb1, 0x3e, 0x6d, 0x31, 0xff, 0x84, 0x34, 0x62, 0x3d, 0xca, 0x34, 0x1a, 0x92, 0x35, 0xdf, 0x7f,
	0xfa, 0x58, 0x97, 0x51, 0xf9, 0xac, 0x8f, 0xa0, 0xa1, 0xcd, 0x76, 0x04, 0xf5, 0x57, 0xc3, 0x68,
	0xac, 0x3b, 0xc1, 0xeb, 0x34, 0xa6, 0x01, 0x9e, 0xff, 0x7d, 0x86, 0xcb, 0x17, 0x23, 0x7a, 0x31,
	0xa2, 0x7f, 0x71, 0x44, 0x9b, 0x3b, 0xc5, 0x1d, 0xaf, 0xca, 0xe0, 0xa7, 0x08, 0xf5, 0x41, 0x3c,
	0x9b, 0xaf, 0xf7, 0x53, 0xa7, 0x60, 0xce, 0x54, 0xeb, 0x55, 0x1e, 0x1b, 0x43, 0x2d, 0x6e, 0x43,
	0x1e, 0x9b, 0xde, 0xae, 0xb5, 0xe4, 0xb1, 0xb1, 0x20, 0x69, 0xf9, 0x62, 0xf5, 0xf6, 0x61, 0x87,
	0x94, 0x8e, 0x3a, 0xa4, 0xf4, 0xa5, 0x43, 0x4a, 0x27, 0x1d, 0x52, 0x7a, 0x99, 0x12, 0xed, 0x5d,
	0x4a, 0x4a, 0x87, 0x29, 0xd1, 0x8e, 0x52, 0xa2, 0x7d, 0x4b, 0x89, 0xf6, 0x23, 0x25, 0xa5, 0x93,
	0x94, 0x68, 0x6f, 0xbe, 0x93, 0xd2, 0xcf, 0xcf, 0xc7, 0x07, 0x03, 0xda, 0xeb, 0xaf, 0xc7, 0x07,
	0x03, 0xf2, 0x6e, 0x6e, 0x8d, 0x48, 0x2f, 0xd7, 0x7f, 0x05, 0x00, 0x00, 0xff, 0xff, 0xb8, 0xc2,
	0xd1, 0x82, 0x7a, 0x07, 0x00, 0x00,
}
