import { DepGraph } from '@snyk/dep-graph';
interface Options {
    debug?: boolean;
    dev?: boolean;
    file?: string;
    'project-name'?: string;
    allProjects?: boolean;
}
export interface MultiProjectResult {
    plugin: {
        name: string;
        runtime: string | undefined;
        targetFile: string;
    };
    scannedProjects: ScannedProject[];
}
export interface ScannedProject {
    packageManager: string;
    depGraph?: DepGraph;
    targetFile: string;
    meta?: any;
}
export declare function inspect(root: string, targetFile: string, options?: Options): Promise<MultiProjectResult>;
export {};
