"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.inspect = void 0;
const subProcess = require("./sub-process");
const scan_1 = require("./scan");
const PLUGIN_NAME = 'snyk-hex-plugin';
async function inspect(root, targetFile, options = {}) {
    const { debug, dev, allProjects, 'project-name': projectName } = options;
    const [scanResult, pluginVersion] = await Promise.all([
        scan_1.scan({ debug, dev, allProjects, projectName, path: root, targetFile }),
        getPluginVersion(),
    ]);
    const scannedProjects = scanResult.scanResults.map(({ identity, facts: [{ data: depGraph }], name }) => ({
        packageManager: 'hex',
        targetFile: identity.targetFile,
        depGraph,
        ...(name ? { meta: { projectName: name } } : {}),
    }));
    return {
        plugin: {
            name: PLUGIN_NAME,
            runtime: pluginVersion,
            targetFile: 'mix.exs',
        },
        scannedProjects,
    };
}
exports.inspect = inspect;
async function getPluginVersion() {
    const output = await subProcess.execute('mix', ['-v']);
    const versionMatch = /(Mix\s\d+\.\d+\.\d*)/.exec(output);
    return versionMatch ? versionMatch[0] : 'Unknown version';
}
//# sourceMappingURL=inspect.js.map