"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmitterDC = void 0;
const events_1 = require("events");
// eslint-disable-next-line no-shadow
var CUSTOM_EVENTS;
(function (CUSTOM_EVENTS) {
    CUSTOM_EVENTS["supportedFilesLoaded"] = "supportedFilesLoaded";
    CUSTOM_EVENTS["scanFilesProgress"] = "scanFilesProgress";
    CUSTOM_EVENTS["createBundleProgress"] = "createBundleProgress";
    CUSTOM_EVENTS["uploadBundleProgress"] = "uploadBundleProgress";
    CUSTOM_EVENTS["analyseProgress"] = "analyseProgress";
    CUSTOM_EVENTS["apiRequestLog"] = "apiRequestLog";
    CUSTOM_EVENTS["error"] = "error";
})(CUSTOM_EVENTS || (CUSTOM_EVENTS = {}));
class EmitterDC extends events_1.EventEmitter {
    constructor() {
        super(...arguments);
        this.events = CUSTOM_EVENTS;
    }
    supportedFilesLoaded(data) {
        this.emit(CUSTOM_EVENTS.supportedFilesLoaded, data);
    }
    scanFilesProgress(processed) {
        this.emit(CUSTOM_EVENTS.scanFilesProgress, processed);
    }
    createBundleProgress(processed, total) {
        this.emit(CUSTOM_EVENTS.createBundleProgress, processed, total);
    }
    uploadBundleProgress(processed, total) {
        this.emit(CUSTOM_EVENTS.uploadBundleProgress, processed, total);
    }
    analyseProgress(data) {
        this.emit(CUSTOM_EVENTS.analyseProgress, data);
    }
    sendError(error) {
        this.emit(CUSTOM_EVENTS.error, error);
    }
    apiRequestLog(message) {
        this.emit(CUSTOM_EVENTS.apiRequestLog, message);
    }
}
exports.EmitterDC = EmitterDC;
const emitter = new EmitterDC();
exports.default = emitter;
//# sourceMappingURL=emitter.js.map