import { Cache } from './cache';
import { ISupportedFiles, IFileInfo } from './interfaces/files.interface';
export declare function notEmpty<T>(value: T | null | undefined): value is T;
export declare function parseFileIgnores(path: string): string[];
export declare function getGlobPatterns(supportedFiles: ISupportedFiles): string[];
export declare function collectIgnoreRules(dirs: string[], symlinksEnabled?: boolean, fileIgnores?: string[]): Promise<string[]>;
export declare function determineBaseDir(paths: string[]): string;
/**
 * Returns bundle files from requested paths
 * */
export declare function collectBundleFiles(baseDir: string, paths: string[], supportedFiles: ISupportedFiles, fileIgnores?: string[], maxFileSize?: number, symlinksEnabled?: boolean): AsyncGenerator<IFileInfo>;
export declare function prepareExtendingBundle(baseDir: string, files: string[], supportedFiles: ISupportedFiles, fileIgnores?: string[], maxFileSize?: number, symlinksEnabled?: boolean): Promise<{
    files: IFileInfo[];
    removedFiles: string[];
}>;
export declare function getFileInfo(filePath: string, baseDir: string, withContent?: boolean, cache?: Cache | null): Promise<IFileInfo | null>;
export declare function resolveBundleFiles(baseDir: string, bundleMissingFiles: string[]): Promise<IFileInfo[]>;
export declare function resolveBundleFilePath(baseDir: string, bundleFilePath: string): string;
export declare function composeFilePayloads(files: IFileInfo[], bucketSize?: number): Generator<IFileInfo[]>;
export declare function isMatch(filePath: string, rules: string[]): boolean;
