export interface PkgTree {
    name: string;
    version: string;
    dependencies: {
        [dep: string]: PkgTree;
    };
    depType?: DepType;
    hasDevDependencies?: boolean;
    cyclic?: boolean;
    targetFrameworks?: string[];
    dependenciesWithUnknownVersions?: string[];
}
export interface DependencyWithoutVersion {
    name: string;
    withoutVersion: true;
}
export declare enum DepType {
    prod = "prod",
    dev = "dev"
}
export interface ReferenceInclude {
    Version?: string;
    Culture?: string;
    processorArchitecture?: string;
    PublicKeyToken?: string;
    name?: string;
}
export interface DependenciesDiscoveryResult {
    dependencies: {
        [dep: string]: PkgTree;
    };
    hasDevDependencies: boolean;
    dependenciesWithUnknownVersions?: string[];
}
export declare enum ProjectJsonDepType {
    build = "build",
    project = "project",
    platform = "platform",
    default = "default"
}
export interface ProjectJsonManifestDependency {
    version: string;
    type?: ProjectJsonDepType;
}
export interface ProjectJsonManifest {
    dependencies: {
        [name: string]: ProjectJsonManifestDependency | string;
    };
}
export declare function getDependencyTreeFromProjectJson(manifestFile: ProjectJsonManifest, includeDev?: boolean): PkgTree;
export declare function getDependencyTreeFromPackagesConfig(manifestFile: any, includeDev?: boolean): Promise<PkgTree>;
export declare function getDependencyTreeFromProjectFile(manifestFile: any, includeDev?: boolean, propsMap?: PropsLookup): Promise<PkgTree>;
export declare function parseXmlFile(manifestFileContents: string): Promise<object>;
export interface PropsLookup {
    [name: string]: string;
}
export declare function getPropertiesMap(propsContents: any): PropsLookup;
export declare function getTargetFrameworksFromProjectFile(manifestFile: any): any;
export declare function getTargetFrameworksFromProjectConfig(manifestFile: any): string[];
export declare function getTargetFrameworksFromProjectJson(manifestFile: any): string[];
export declare function getTargetFrameworksFromProjectAssetsJson(manifestFile: any): string[];
