"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateDockerfileBaseImageName = exports.getDockerfileBaseImageName = exports.getPackagesFromDockerfile = exports.instructionDigest = exports.readDockerfileAndAnalyse = exports.analyseDockerfile = void 0;
const dockerfile_ast_1 = require("dockerfile-ast");
const fs = require("fs");
const path_1 = require("path");
const instruction_parser_1 = require("./instruction-parser");
Object.defineProperty(exports, "getDockerfileBaseImageName", { enumerable: true, get: function () { return instruction_parser_1.getDockerfileBaseImageName; } });
Object.defineProperty(exports, "getPackagesFromDockerfile", { enumerable: true, get: function () { return instruction_parser_1.getPackagesFromDockerfile; } });
Object.defineProperty(exports, "instructionDigest", { enumerable: true, get: function () { return instruction_parser_1.instructionDigest; } });
const instruction_updater_1 = require("./instruction-updater");
Object.defineProperty(exports, "updateDockerfileBaseImageName", { enumerable: true, get: function () { return instruction_updater_1.updateDockerfileBaseImageName; } });
async function readDockerfileAndAnalyse(dockerfilePath) {
    if (!dockerfilePath) {
        return undefined;
    }
    const contents = await readFile(path_1.normalize(dockerfilePath));
    return analyseDockerfile(contents);
}
exports.readDockerfileAndAnalyse = readDockerfileAndAnalyse;
async function analyseDockerfile(contents) {
    const dockerfile = dockerfile_ast_1.DockerfileParser.parse(contents);
    const baseImage = instruction_parser_1.getDockerfileBaseImageName(dockerfile);
    const dockerfilePackages = instruction_parser_1.getPackagesFromDockerfile(dockerfile);
    const dockerfileLayers = instruction_parser_1.getLayersFromPackages(dockerfilePackages);
    return {
        baseImage,
        dockerfilePackages,
        dockerfileLayers,
    };
}
exports.analyseDockerfile = analyseDockerfile;
async function readFile(path) {
    return new Promise((resolve, reject) => {
        fs.readFile(path, "utf8", (err, data) => {
            return err ? reject(err) : resolve(data);
        });
    });
}
//# sourceMappingURL=index.js.map