"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRedHatReposFromExtractedLayers = exports.getRedHatReposContentAction = void 0;
const stream_utils_1 = require("../../stream-utils");
exports.getRedHatReposContentAction = {
    actionName: "redhat-content-manifests",
    filePathMatches: isRedHatContentManifest,
    callback: stream_utils_1.streamToJson,
};
function getRedHatReposFromExtractedLayers(extractedLayers) {
    var _a;
    const reposByLayer = {};
    for (const filePath in extractedLayers) {
        if (isRedHatContentManifest(filePath)) {
            const content = extractedLayers[filePath]["redhat-content-manifests"];
            const layerIndex = (_a = content === null || content === void 0 ? void 0 : content.metadata) === null || _a === void 0 ? void 0 : _a.image_layer_index;
            const repos = content === null || content === void 0 ? void 0 : content.content_sets;
            if (layerIndex && repos) {
                reposByLayer[layerIndex] = repos;
            }
        }
    }
    return reposByLayer;
}
exports.getRedHatReposFromExtractedLayers = getRedHatReposFromExtractedLayers;
function isRedHatContentManifest(filePath) {
    return filePath.startsWith("/root/buildinfo/content_manifests/");
}
//# sourceMappingURL=static.js.map