import { IacFileData, IacFileParsed, IaCTestFlags, ParsingResults } from './types';
import { CustomError } from '../../../../lib/errors';
export declare function parseFiles(filesData: IacFileData[], options?: IaCTestFlags): Promise<ParsingResults>;
export declare function tryParseIacFile(fileData: IacFileData, options?: IaCTestFlags): IacFileParsed[];
export declare class UnsupportedFileTypeError extends CustomError {
    constructor(fileType: string);
}
export declare class InvalidJsonFileError extends CustomError {
    constructor(filename: string);
}
export declare class InvalidYamlFileError extends CustomError {
    constructor(filename: string);
}
export declare class FailedToDetectJsonConfigError extends CustomError {
    constructor(filename: string);
}
