"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IaCErrorCodes = exports.VALID_RESOURCE_ACTIONS_FOR_FULL_SCAN = exports.VALID_RESOURCE_ACTIONS_FOR_DELTA_SCAN = exports.TerraformPlanScanMode = exports.EngineType = exports.VALID_FILE_TYPES = void 0;
exports.VALID_FILE_TYPES = ['tf', 'json', 'yaml', 'yml'];
var EngineType;
(function (EngineType) {
    EngineType[EngineType["Kubernetes"] = 0] = "Kubernetes";
    EngineType[EngineType["Terraform"] = 1] = "Terraform";
    EngineType[EngineType["CloudFormation"] = 2] = "CloudFormation";
    EngineType[EngineType["Custom"] = 3] = "Custom";
})(EngineType = exports.EngineType || (exports.EngineType = {}));
var TerraformPlanScanMode;
(function (TerraformPlanScanMode) {
    TerraformPlanScanMode["DeltaScan"] = "resource-changes";
    TerraformPlanScanMode["FullScan"] = "planned-values";
})(TerraformPlanScanMode = exports.TerraformPlanScanMode || (exports.TerraformPlanScanMode = {}));
// we will be scanning the `create` & `update` actions only.
exports.VALID_RESOURCE_ACTIONS_FOR_DELTA_SCAN = [
    ['create'],
    ['update'],
    ['create', 'delete'],
    ['delete', 'create'],
];
// scans all actions including 'no-op' in order to iterate on all resources.
exports.VALID_RESOURCE_ACTIONS_FOR_FULL_SCAN = [
    ['no-op'],
    ...exports.VALID_RESOURCE_ACTIONS_FOR_DELTA_SCAN,
];
// Error codes used for Analytics & Debugging
// Error names get converted to error string codes
// Within a single module, increments are in 1.
// Between modules, increments are in 10, according to the order of execution.
var IaCErrorCodes;
(function (IaCErrorCodes) {
    // local-cache errors
    IaCErrorCodes[IaCErrorCodes["FailedToInitLocalCacheError"] = 1000] = "FailedToInitLocalCacheError";
    IaCErrorCodes[IaCErrorCodes["FailedToCleanLocalCacheError"] = 1001] = "FailedToCleanLocalCacheError";
    IaCErrorCodes[IaCErrorCodes["FailedToDownloadRulesError"] = 1002] = "FailedToDownloadRulesError";
    IaCErrorCodes[IaCErrorCodes["FailedToExtractCustomRulesError"] = 1003] = "FailedToExtractCustomRulesError";
    // file-loader errors
    IaCErrorCodes[IaCErrorCodes["NoFilesToScanError"] = 1010] = "NoFilesToScanError";
    IaCErrorCodes[IaCErrorCodes["FailedToLoadFileError"] = 1011] = "FailedToLoadFileError";
    // file-parser errors
    IaCErrorCodes[IaCErrorCodes["UnsupportedFileTypeError"] = 1020] = "UnsupportedFileTypeError";
    IaCErrorCodes[IaCErrorCodes["InvalidJsonFileError"] = 1021] = "InvalidJsonFileError";
    IaCErrorCodes[IaCErrorCodes["InvalidYamlFileError"] = 1022] = "InvalidYamlFileError";
    IaCErrorCodes[IaCErrorCodes["FailedToDetectJsonConfigError"] = 1023] = "FailedToDetectJsonConfigError";
    IaCErrorCodes[IaCErrorCodes["FailedToDetectYamlConfigError"] = 1024] = "FailedToDetectYamlConfigError";
    // kubernetes-parser errors
    IaCErrorCodes[IaCErrorCodes["MissingRequiredFieldsInKubernetesYamlError"] = 1031] = "MissingRequiredFieldsInKubernetesYamlError";
    IaCErrorCodes[IaCErrorCodes["FailedToParseHelmError"] = 1032] = "FailedToParseHelmError";
    // terraform-file-parser errors
    IaCErrorCodes[IaCErrorCodes["FailedToParseTerraformFileError"] = 1040] = "FailedToParseTerraformFileError";
    // terraform-plan-parser errors
    IaCErrorCodes[IaCErrorCodes["FailedToExtractResourcesInTerraformPlanError"] = 1052] = "FailedToExtractResourcesInTerraformPlanError";
    // file-scanner errors
    IaCErrorCodes[IaCErrorCodes["FailedToBuildPolicyEngine"] = 1060] = "FailedToBuildPolicyEngine";
    IaCErrorCodes[IaCErrorCodes["FailedToExecutePolicyEngine"] = 1061] = "FailedToExecutePolicyEngine";
    // results-formatter errors
    IaCErrorCodes[IaCErrorCodes["FailedToFormatResults"] = 1070] = "FailedToFormatResults";
    IaCErrorCodes[IaCErrorCodes["FailedToExtractLineNumberError"] = 1071] = "FailedToExtractLineNumberError";
    // get-iac-org-settings errors
    IaCErrorCodes[IaCErrorCodes["FailedToGetIacOrgSettingsError"] = 1080] = "FailedToGetIacOrgSettingsError";
    // assert-iac-options-flag
    IaCErrorCodes[IaCErrorCodes["FlagError"] = 1090] = "FlagError";
    IaCErrorCodes[IaCErrorCodes["FlagValueError"] = 1091] = "FlagValueError";
})(IaCErrorCodes = exports.IaCErrorCodes || (exports.IaCErrorCodes = {}));
//# sourceMappingURL=types.js.map