import * as needle from 'needle';
/**
 *
 * @param data the data to merge into that data which has been staged thus far (with the {@link add} function)
 * and then sent to the backend.
 */
export declare function addDataAndSend(data: any): Promise<void | {
    res: needle.NeedleResponse;
    body: any;
}>;
export declare function allowAnalytics(): boolean;
/**
 * Actually send the analytics to the backend. This can be used standalone to send only the data
 * given by the data parameter, or called from {@link addDataAndSend}.
 * @param data the analytics data to send to the backend.
 */
export declare function postAnalytics(data: any): Promise<void | {
    res: needle.NeedleResponse;
    body: any;
}>;
/**
 * Adds a key-value pair to the analytics data `metadata` field. This doesn't send the analytis, just stages it for
 * sending later (via the {@link addDataAndSend} function).
 * @param key
 * @param value
 */
export declare function add(key: any, value: any): void;
