"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.actionAllowed = void 0;
const snyk = require("./");
const request = require("./request");
const config = require("./config");
async function actionAllowed(action, options) {
    const org = options.org || config.org || null;
    try {
        const res = await request({
            method: 'GET',
            url: config.API + '/authorization/' + action,
            json: true,
            headers: {
                authorization: 'token ' + snyk.api,
            },
            qs: org && { org },
        });
        return res.body.result;
    }
    catch (err) {
        return {
            allowed: false,
            reason: 'There was an error while checking authorization',
        };
    }
}
exports.actionAllowed = actionAllowed;
//# sourceMappingURL=authorization.js.map