"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEcosystem = exports.getEcosystemForTest = void 0;
var test_1 = require("./test");
Object.defineProperty(exports, "testEcosystem", { enumerable: true, get: function () { return test_1.testEcosystem; } });
var monitor_1 = require("./monitor");
Object.defineProperty(exports, "monitorEcosystem", { enumerable: true, get: function () { return monitor_1.monitorEcosystem; } });
var plugins_1 = require("./plugins");
Object.defineProperty(exports, "getPlugin", { enumerable: true, get: function () { return plugins_1.getPlugin; } });
/**
 * Ecosystems are listed here if you opt in to the new plugin test flow.
 * This is a breaking change to the old plugin formats, so only a select few
 * plugins currently work with it.
 *
 * Currently container scanning is not yet ready to work with this flow,
 * hence this is in a separate function from getEcosystem().
 */
function getEcosystemForTest(options) {
    if (options.source) {
        return 'cpp';
    }
    if (options.code) {
        return 'code';
    }
    return null;
}
exports.getEcosystemForTest = getEcosystemForTest;
function getEcosystem(options) {
    if (options.source) {
        return 'cpp';
    }
    if (options.docker) {
        return 'docker';
    }
    return null;
}
exports.getEcosystem = getEcosystem;
//# sourceMappingURL=index.js.map