"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeatureNotSupportedForOrgError = void 0;
const custom_error_1 = require("./custom-error");
class FeatureNotSupportedForOrgError extends custom_error_1.CustomError {
    constructor(org, feature = 'Feature', additionalUserHelp = '') {
        super(`Unsupported action for org ${org}.`);
        this.code = 422;
        this.org = org;
        this.userMessage =
            `${feature} is not supported for org` +
                (org ? ` ${org}` : '') +
                (additionalUserHelp ? `: ${additionalUserHelp}` : '.');
    }
}
exports.FeatureNotSupportedForOrgError = FeatureNotSupportedForOrgError;
//# sourceMappingURL=unsupported-feature-for-org-error.js.map