export declare type IacProjectTypes = 'k8sconfig' | 'terraformconfig' | 'cloudformationconfig' | 'customconfig' | 'multiiacconfig';
export declare type IacFileTypes = 'yaml' | 'yml' | 'json' | 'tf';
export declare enum IacProjectType {
    K8S = "k8sconfig",
    TERRAFORM = "terraformconfig",
    CLOUDFORMATION = "cloudformationconfig",
    CUSTOM = "customconfig",
    MULTI_IAC = "multiiacconfig"
}
export declare const TEST_SUPPORTED_IAC_PROJECTS: IacProjectTypes[];
export declare const projectTypeByFileType: {
    yaml: IacProjectType;
    yml: IacProjectType;
    json: IacProjectType;
    tf: IacProjectType;
};
export declare type IacValidateTerraformResponse = {
    body?: {
        isValidTerraformFile: boolean;
        reason: string;
    };
};
export interface IacValidationResponse {
    isValidFile: boolean;
    reason: string;
}
