"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartThreshold = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _hoistNonReactStatics = _interopRequireDefault(require("hoist-non-react-statics"));

var _lodash = require("lodash");

var _victory = require("victory");

var _ChartLine = require("../ChartLine");

var _ChartUtils = require("../ChartUtils");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var ChartThreshold = function ChartThreshold(_ref) {
  var _ref$style = _ref.style,
      style = _ref$style === void 0 ? {} : _ref$style,
      themeColor = _ref.themeColor,
      themeVariant = _ref.themeVariant,
      _ref$theme = _ref.theme,
      theme = _ref$theme === void 0 ? (0, _ChartUtils.getThresholdTheme)(themeColor, themeVariant) : _ref$theme,
      rest = _objectWithoutProperties(_ref, ["style", "themeColor", "themeVariant", "theme"]);

  // Returned style prop takes precedence over default theme
  var getStrokeDasharray = function getStrokeDasharray() {
    if (style && style.data && style.data.strokeDasharray) {
      return style.data.strokeDasharray;
    }

    return (0, _ChartUtils.getThresholdTheme)(themeColor, themeVariant).line.style.data.strokeDasharray;
  };

  var getStrokeWidth = function getStrokeWidth() {
    if (style && style.data && style.data.strokeWidth) {
      return style.data.strokeWidth;
    }

    return (0, _ChartUtils.getThresholdTheme)(themeColor, themeVariant).line.style.data.strokeWidth;
  }; // Clone style and apply strokeDasharray prop


  var thresholdStyle = (0, _lodash.cloneDeep)(style);

  if (thresholdStyle.data) {
    thresholdStyle.data.strokeDasharray = getStrokeDasharray();
    thresholdStyle.data.strokeWidth = getStrokeWidth();
  } else {
    thresholdStyle.data = {
      strokeDasharray: getStrokeDasharray(),
      strokeWidth: getStrokeWidth()
    };
  }

  return React.createElement(_ChartLine.ChartLine, _extends({
    style: thresholdStyle,
    theme: theme
  }, rest));
}; // Note: VictoryLine.role must be hoisted


exports.ChartThreshold = ChartThreshold;
ChartThreshold.propTypes = {
  animate: _propTypes["default"].any,
  categories: _propTypes["default"].any,
  containerComponent: _propTypes["default"].element,
  data: _propTypes["default"].arrayOf(_propTypes["default"].any),
  dataComponent: _propTypes["default"].element,
  domain: _propTypes["default"].any,
  domainPadding: _propTypes["default"].any,
  eventKey: _propTypes["default"].any,
  events: _propTypes["default"].arrayOf(_propTypes["default"].any),
  externalEventMutations: _propTypes["default"].arrayOf(_propTypes["default"].any),
  groupComponent: _propTypes["default"].element,
  height: _propTypes["default"].number,
  horizontal: _propTypes["default"].bool,
  interpolation: _propTypes["default"].any,
  labelComponent: _propTypes["default"].element,
  labels: _propTypes["default"].oneOfType([_propTypes["default"].any, _propTypes["default"].arrayOf(_propTypes["default"].string), _propTypes["default"].arrayOf(_propTypes["default"].number)]),
  maxDomain: _propTypes["default"].oneOfType([_propTypes["default"].number, _propTypes["default"].shape({
    x: _propTypes["default"].number,
    y: _propTypes["default"].number
  })]),
  minDomain: _propTypes["default"].oneOfType([_propTypes["default"].number, _propTypes["default"].shape({
    x: _propTypes["default"].number,
    y: _propTypes["default"].number
  })]),
  name: _propTypes["default"].string,
  origin: _propTypes["default"].shape({
    x: _propTypes["default"].number.isRequired,
    y: _propTypes["default"].number.isRequired
  }),
  padding: _propTypes["default"].any,
  polar: _propTypes["default"].bool,
  range: _propTypes["default"].oneOfType([_propTypes["default"].shape({})]),
  samples: _propTypes["default"].number,
  scale: _propTypes["default"].oneOfType([_propTypes["default"].any, _propTypes["default"].any, _propTypes["default"].shape({
    x: _propTypes["default"].oneOfType([_propTypes["default"].any, _propTypes["default"].any]),
    y: _propTypes["default"].oneOfType([_propTypes["default"].any, _propTypes["default"].any])
  })])
};
(0, _hoistNonReactStatics["default"])(ChartThreshold, _victory.VictoryLine);
//# sourceMappingURL=ChartThreshold.js.map