"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatChangesSummary = void 0;
const chalk = require("chalk");
const format_display_name_1 = require("./format-display-name");
const show_results_summary_1 = require("./show-results-summary");
/*
 * Generate formatted output that describes what changes were applied, which failed.
 */
function formatChangesSummary(entity, changes) {
    return `${show_results_summary_1.PADDING_SPACE}${format_display_name_1.formatDisplayName(entity.workspace.path, entity.scanResult.identity)}\n${changes.map((c) => formatAppliedChange(c)).join('\n')}`;
}
exports.formatChangesSummary = formatChangesSummary;
function formatAppliedChange(change) {
    if (change.success === true) {
        return `${show_results_summary_1.PADDING_SPACE}${chalk.green('✔')} ${change.userMessage}`;
    }
    if (change.success === false) {
        return `${show_results_summary_1.PADDING_SPACE}${chalk.red('x')} ${chalk.red(change.userMessage)}\n${show_results_summary_1.PADDING_SPACE}Reason:${show_results_summary_1.PADDING_SPACE}${change.reason}${change.tip ? `.\n${show_results_summary_1.PADDING_SPACE}Tip:     ${change.tip}` : undefined}`;
    }
    return '';
}
//# sourceMappingURL=format-successful-item.js.map