"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateDependencies = void 0;
const debugLib = require("debug");
const generate_pins_1 = require("./generate-pins");
const apply_upgrades_1 = require("./apply-upgrades");
const generate_upgrades_1 = require("./generate-upgrades");
const failed_to_parse_manifest_1 = require("../../../../../lib/errors/failed-to-parse-manifest");
const debug = debugLib('snyk-fix:python:update-dependencies');
/*
 * Given contents of manifest file(s) and a set of upgrades, apply the given
 * upgrades to a manifest and return the upgraded manifest.
 *
 * Currently only supported for `requirements.txt` - at least one file named
 * `requirements.txt` must be in the manifests.
 */
function updateDependencies(parsedRequirementsData, updates, directUpgradesOnly = false, referenceFileInChanges) {
    const { requirements, endsWithNewLine: shouldEndWithNewLine, } = parsedRequirementsData;
    if (!requirements.length) {
        debug('Error: Expected to receive parsed manifest data. Is manifest empty?');
        throw new failed_to_parse_manifest_1.FailedToParseManifest();
    }
    debug('Finished parsing manifest');
    const { updatedRequirements, changes: upgradedChanges } = generate_upgrades_1.generateUpgrades(requirements, updates, referenceFileInChanges);
    debug('Finished generating upgrades to apply');
    let pinnedRequirements = [];
    let pinChanges = [];
    if (!directUpgradesOnly) {
        ({ pinnedRequirements, changes: pinChanges } = generate_pins_1.generatePins(requirements, updates, referenceFileInChanges));
        debug('Finished generating pins to apply');
    }
    let updatedManifest = [
        ...apply_upgrades_1.applyUpgrades(requirements, updatedRequirements),
        ...pinnedRequirements,
    ].join('\n');
    // This is a bit of a hack, but an easy one to follow. If a file ends with a
    // new line, ensure we keep it this way. Don't hijack customers formatting.
    if (shouldEndWithNewLine) {
        updatedManifest += '\n';
    }
    debug('Finished applying changes to manifest');
    return {
        updatedManifest,
        changes: [...pinChanges, ...upgradedChanges],
    };
}
exports.updateDependencies = updateDependencies;
//# sourceMappingURL=index.js.map