(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "react", "../components/Table"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("react"), require("../components/Table"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.react, global.Table);
    global.undefined = mod.exports;
  }
})(this, function (exports, _react, _Table) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.actions = exports.editableRows = exports.editableColumns = exports.rows = exports.columns = undefined;

  var React = _interopRequireWildcard(_react);

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;
    var cache = new WeakMap();

    _getRequireWildcardCache = function () {
      return cache;
    };

    return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }

    var cache = _getRequireWildcardCache();

    if (cache && cache.has(obj)) {
      return cache.get(obj);
    }

    var newObj = {};

    if (obj != null) {
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
    }

    newObj.default = obj;

    if (cache) {
      cache.set(obj, newObj);
    }

    return newObj;
  }

  /* eslint-disable no-console */
  const columns = exports.columns = [{
    title: 'Header cell'
  }, 'Branches', {
    title: 'Pull requests'
  }, 'Workspaces', {
    title: 'Last Commit'
  }];
  const rows = exports.rows = [{
    cells: ['one', 'two', 'three', 'four', 'five']
  }, {
    cells: ['one', 'two', 'three', 'four', 'five']
  }, {
    cells: ['one', 'two', 'three', 'four', 'five']
  }, {
    cells: ['one', 'two', 'three', 'four', 'five']
  }, {
    cells: ['one', 'two', 'three', 'four', 'five']
  }, {
    cells: ['one', 'two', 'three', 'four', 'five']
  }, {
    cells: ['one', 'two', 'three', 'four', 'five']
  }, {
    cells: ['one', 'two', 'three', 'four', 'five']
  }, {
    cells: ['one', 'two', 'three', 'four', 'five']
  }];
  const editableColumns = exports.editableColumns = ['Text input col 1', 'Disabled text input col 2', 'Text input col 3', 'Text input col 4'];
  const editableRows = exports.editableRows = [{
    isEditable: true,
    cells: [{
      title: (value, rowIndex, cellIndex, props) => React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        handleTextInputChange: () => {},
        inputAriaLabel: "Row 1 cell 1 content"
      }),
      props: {
        value: 'Row 1 cell 1 content',
        name: 'uniqueIdRow1Cell1'
      }
    }, {
      title: (value, rowIndex, cellIndex, props) => React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        isDisabled: true,
        handleTextInputChange: () => {},
        inputAriaLabel: "Row 1 cell 2 content"
      }),
      props: {
        value: 'Row 1 cell 2, disabled content',
        name: 'uniqueIdRow1Cell2'
      }
    }, {
      title: (value, rowIndex, cellIndex, props) => React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        handleTextInputChange: () => {},
        inputAriaLabel: "Row 1 cell 3 content"
      }),
      props: {
        value: 'Row 1 cell 3 content',
        name: 'uniqueIdRow1Cell3'
      }
    }, {
      title: (value, rowIndex, cellIndex, props) => React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        handleTextInputChange: () => {},
        inputAriaLabel: "Row 1 cell 4 content"
      }),
      props: {
        value: 'Row 1 cell 4 content',
        name: 'uniqueIdRow1Cell4'
      }
    }]
  }, {
    isEditable: false,
    cells: [{
      title: (value, rowIndex, cellIndex, props) => React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        handleTextInputChange: () => {},
        inputAriaLabel: "Row 1 cell 1 content"
      }),
      props: {
        value: 'Row 2 cell 1 content',
        name: 'uniqueIdRow2Cell1'
      }
    }, {
      title: (value, rowIndex, cellIndex, props) => React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        isDisabled: true,
        handleTextInputChange: () => {},
        inputAriaLabel: "Row 2 cell 2 content"
      }),
      props: {
        value: 'Row 2 cell 2, disabled content',
        name: 'uniqueIdRow2Cell2'
      }
    }, {
      title: (value, rowIndex, cellIndex, props) => React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        handleTextInputChange: () => {},
        inputAriaLabel: "Row 2 cell 3 content"
      }),
      props: {
        value: 'Row 2 cell 3 content',
        name: 'uniqueIdRow2Cell3'
      }
    }, {
      title: (value, rowIndex, cellIndex, props) => React.createElement(_Table.EditableTextCell, {
        value: value,
        rowIndex: rowIndex,
        cellIndex: cellIndex,
        props: props,
        handleTextInputChange: () => {},
        inputAriaLabel: "Row 2 cell 4 content"
      }),
      props: {
        value: 'Row 2 cell 4 content',
        name: 'uniqueIdRow2Cell4'
      }
    }]
  }];
  const actions = exports.actions = [{
    title: 'Some action',
    onClick: (event, rowId) => // tslint:disable-next-line:no-console
    console.log('clicked on Some action, on row: ', rowId)
  }, {
    title: React.createElement("div", null, "Another action"),
    onClick: (event, rowId) => // tslint:disable-next-line:no-console
    console.log('clicked on Another action, on row: ', rowId)
  }, {
    isSeparator: true,
    onClick: null
  }, {
    title: 'Third action',
    onClick: (event, rowId) => // tslint:disable-next-line:no-console
    console.log('clicked on Third action, on row: ', rowId)
  }];
});
//# sourceMappingURL=data-sets.js.map