import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import AngleRightIcon from '@patternfly/react-icons/dist/js/icons/angle-right-icon';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/NotificationDrawer/notification-drawer';
import { Badge } from '../Badge';
export const NotificationDrawerGroup = (_ref) => {
  let {
    children,
    className = '',
    count,
    isExpanded,
    isRead = false,
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onExpand = (event, expanded) => undefined,
    title
  } = _ref,
      props = _objectWithoutProperties(_ref, ["children", "className", "count", "isExpanded", "isRead", "onExpand", "title"]);

  return React.createElement("section", _extends({}, props, {
    className: css(styles.notificationDrawerGroup, isExpanded && styles.modifiers.expanded, className)
  }), React.createElement("h1", null, React.createElement("button", {
    className: css(styles.notificationDrawerGroupToggle),
    "aria-expanded": isExpanded,
    onClick: e => onExpand(e, !isExpanded)
  }, React.createElement("div", null, title), React.createElement("div", {
    className: css(styles.notificationDrawerGroupToggleCount)
  }, React.createElement(Badge, {
    isRead: isRead
  }, count)), React.createElement("span", {
    className: "pf-c-notification-drawer__group-toggle-icon"
  }, React.createElement(AngleRightIcon, null)))), children);
};
NotificationDrawerGroup.propTypes = {
  children: _pt.node,
  className: _pt.string,
  count: _pt.number.isRequired,
  isExpanded: _pt.bool.isRequired,
  isRead: _pt.bool,
  onExpand: _pt.func,
  title: _pt.string.isRequired
};
//# sourceMappingURL=NotificationDrawerGroup.js.map