import { getModifier } from '@patternfly/react-styles';
export let GutterSize;
/**
 * @param {any} styleObj - Style object
 * @param {'sm' | 'md' | 'lg'} size - Size string 'sm', 'md', or 'lg'
 * @param {any} defaultValue - Default value
 */

(function (GutterSize) {
  GutterSize["sm"] = "sm";
  GutterSize["md"] = "md";
  GutterSize["lg"] = "lg";
})(GutterSize || (GutterSize = {}));

export function getGutterModifier(styleObj, size, defaultValue) {
  return getModifier(styleObj, `gutter-${size}`, defaultValue);
}
//# sourceMappingURL=gutters.js.map