import { DockerPullResult } from "@snyk/snyk-docker-pull";
import * as subProcess from "./sub-process";
export { Docker, DockerOptions };
interface DockerOptions {
    host?: string;
    tlsVerify?: string;
    tlsCert?: string;
    tlsCaCert?: string;
    tlsKey?: string;
    socketPath?: string;
    platform?: string;
}
declare class Docker {
    static binaryExists(): Promise<boolean>;
    pull(registry: string, repo: string, tag: string, imageSavePath: string, username?: string, password?: string): Promise<DockerPullResult>;
    isDockerExperimentalEnabled(): Promise<boolean>;
    pullCli(targetImage: string, options?: DockerOptions): Promise<subProcess.CmdOutput>;
    save(targetImage: string, destination: string): Promise<void>;
    inspectImage(targetImage: string): Promise<subProcess.CmdOutput>;
}
