/// <reference types="node" />
import { Readable } from "stream";
import { DockerFileAnalysis } from "../dockerfile";
import { Elf } from "../go-parser/types";
export declare type ExtractCallback = (dataStream: Readable, streamSize?: number) => Promise<string | Buffer>;
export declare type FileContent = string | Buffer | Elf;
export declare type FileNameAndContent = Record<string, FileContent>;
export interface ExtractionResult {
    imageId: string;
    manifestLayers: string[];
    extractedLayers: ExtractedLayers;
    rootFsLayers?: string[];
    autoDetectedUserInstructions?: DockerFileAnalysis;
    platform?: string;
    imageLabels?: {
        [key: string]: string;
    };
}
export interface ExtractedLayers {
    [layerName: string]: FileNameAndContent;
}
export interface ExtractedLayersAndManifest {
    layers: ExtractedLayers[];
    manifest: DockerArchiveManifest;
    imageConfig: DockerArchiveImageConfig;
}
export interface DockerArchiveManifest {
    Config: string;
    RepoTags: string[];
    Layers: string[];
}
export interface DockerArchiveImageConfig {
    architecture: string;
    os: string;
    rootfs: {
        diff_ids: string[];
    };
    config: {
        Labels: {
            [key: string]: string;
        };
    };
}
export interface OciArchiveLayer {
    digest: string;
}
export interface OciArchiveManifest {
    schemaVersion: string;
    config: {
        digest: string;
    };
    layers: OciArchiveLayer[];
}
export interface OciManifestInfo {
    digest: string;
    platform?: {
        architecture: string;
        os: string;
    };
}
export interface OciImageIndex {
    manifests: OciManifestInfo[];
}
export interface ExtractAction {
    actionName: string;
    filePathMatches: (filePath: string) => boolean;
    callback?: ExtractCallback;
}
export interface DetectedImageLayers {
    packages: any;
    layers: any;
}
export interface RedHatRepos {
    [imageLayerIndex: string]: RedHatRepo[];
}
export declare type RedHatRepo = string;
