"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNodeAppFileContentAction = void 0;
const path_1 = require("path");
const stream_utils_1 = require("../../stream-utils");
const nodeAppFiles = ["package.json", "package-lock.json", "yarn.lock"];
function filePathMatches(filePath) {
    const fileName = path_1.basename(filePath);
    return (filePath.indexOf("node_modules") === -1 && nodeAppFiles.includes(fileName));
}
exports.getNodeAppFileContentAction = {
    actionName: "node-app-files",
    filePathMatches,
    callback: stream_utils_1.streamToString,
};
//# sourceMappingURL=static.js.map