/// <reference types="node" />
import { Readable } from "stream";
/**
 * https://nodejs.org/api/buffer.html#buffer_buffers_and_character_encodings
 */
declare type SupportedEncodings = "utf8" | "base64";
export declare function streamToString(stream: Readable, streamSize?: number, encoding?: SupportedEncodings): Promise<string>;
export declare function streamToBuffer(stream: Readable): Promise<Buffer>;
export declare function streamToSha256(stream: Readable): Promise<string>;
export declare function streamToSha1(stream: Readable): Promise<string>;
export declare function streamToJson<T>(stream: Readable): Promise<T>;
export {};
