"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.find = void 0;
const fs = require("fs");
const path_1 = require("path");
const util_1 = require("util");
const types_1 = require("./types");
const debug_1 = require("./debug");
const readdir = util_1.promisify(fs.readdir);
const stat = util_1.promisify(fs.stat);
async function find(dir) {
    const result = [];
    const dirStat = await stat(dir);
    if (!dirStat.isDirectory()) {
        throw new Error(`${dir} is not a directory`);
    }
    const paths = await readdir(dir);
    for (const relativePath of paths) {
        const absolutePath = path_1.join(dir, relativePath);
        try {
            const fileStat = await stat(absolutePath);
            if (fileStat.isDirectory()) {
                const subFiles = await find(absolutePath);
                for (const file of subFiles) {
                    result.push(file);
                }
            }
            if (fileStat.isFile()) {
                const ext = path_1.extname(absolutePath);
                if (types_1.SupportFileExtensions.includes(ext)) {
                    result.push(absolutePath);
                }
            }
        }
        catch (error) {
            debug_1.debug(error.message || `Error reading file ${relativePath}. ${error}`);
        }
    }
    return result;
}
exports.find = find;
//# sourceMappingURL=find.js.map