"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findBuildDirs = exports.runtimeMetrics = exports.getCallGraphGradle = exports.getCallGraphMvn = exports.getCallGraphMvnLegacy = void 0;
const tslib_1 = require("tslib");
require("source-map-support/register");
const mvn_wrapper_legacy_1 = require("./mvn-wrapper-legacy");
const gradle_wrapper_1 = require("./gradle-wrapper");
const java_wrapper_1 = require("./java-wrapper");
const metrics_1 = require("./metrics");
const errors_1 = require("./errors");
const promisified_fs_glob_1 = require("./promisified-fs-glob");
const path = require("path");
const mvn_wrapper_1 = require("./mvn-wrapper");
const debug_1 = require("./debug");
const tmp = require("tmp");
tmp.setGracefulCleanup();
function getCallGraphMvnLegacy(targetPath, timeout, customMavenArgs) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        try {
            const [classPath, targets] = yield Promise.all([
                metrics_1.timeIt('getMvnClassPath', () => mvn_wrapper_legacy_1.getClassPathFromMvn(targetPath, customMavenArgs)),
                metrics_1.timeIt('getEntrypoints', () => findBuildDirs(targetPath, 'mvn')),
            ]);
            return yield metrics_1.timeIt('getCallGraph', () => java_wrapper_1.getCallGraph(classPath, targetPath, targets, timeout));
        }
        catch (e) {
            throw new errors_1.CallGraphGenerationError(e.userMessage ||
                'Failed to scan for reachable vulnerabilities. Please contact our support or submit an issue at https://github.com/snyk/java-call-graph-builder/issues. Re-running the command with the `-d` flag will provide useful information for the support engineers.', e);
        }
    });
}
exports.getCallGraphMvnLegacy = getCallGraphMvnLegacy;
function getCallGraphMvn(targetPath, timeout, customMavenArgs) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        try {
            const project = yield mvn_wrapper_1.makeMavenProject(targetPath, customMavenArgs);
            const classPath = project.getClassPath();
            const buildDirectories = yield Promise.all(project.modules.map((m) => m.buildDirectory));
            return yield metrics_1.timeIt('getCallGraph', () => java_wrapper_1.getCallGraph(classPath, targetPath, buildDirectories, timeout));
        }
        catch (e) {
            debug_1.debug(`Failed to get the call graph for the Maven project in: ${targetPath}. ' +
      'Falling back to the legacy method.`);
            return getCallGraphMvnLegacy(targetPath, timeout, customMavenArgs);
        }
    });
}
exports.getCallGraphMvn = getCallGraphMvn;
function getCallGraphGradle(targetPath, gradlePath = 'gradle', initScript, timeout) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const [classPath, targets] = yield Promise.all([
            metrics_1.timeIt('getGradleClassPath', () => gradle_wrapper_1.getClassPathFromGradle(targetPath, gradlePath, initScript)),
            metrics_1.timeIt('getEntrypoints', () => findBuildDirs(targetPath, 'gradle')),
        ]);
        return yield metrics_1.timeIt('getCallGraph', () => java_wrapper_1.getCallGraph(classPath, targetPath, targets, timeout));
    });
}
exports.getCallGraphGradle = getCallGraphGradle;
function runtimeMetrics() {
    return metrics_1.getMetrics();
}
exports.runtimeMetrics = runtimeMetrics;
function findBuildDirs(targetPath, packageManager) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const targetFoldersByPackageManager = {
            mvn: 'target',
            gradle: 'build',
        };
        const targetDirs = yield promisified_fs_glob_1.glob(path.join(targetPath, `**/${targetFoldersByPackageManager[packageManager]}`));
        if (!targetDirs.length) {
            throw new errors_1.MissingTargetFolderError(targetPath, packageManager);
        }
        return targetDirs;
    });
}
exports.findBuildDirs = findBuildDirs;
//# sourceMappingURL=index.js.map