import 'source-map-support/register';
import { ClassPath } from './classpath';
export declare function withOutputToTemporaryFile(f: (fileName: string) => Promise<void>): Promise<string>;
export declare function getBuildDir(baseDir: string, customMavenArgs?: string[]): Promise<string>;
export declare function getOutputDir(baseDir: string, customMavenArgs?: string[]): Promise<string>;
export declare function getDepsClassPath(baseDir: string, customMavenArgs?: string[]): Promise<ClassPath>;
export declare function parseModuleNames(modulesXml: string): string[];
export declare class MavenModule {
    readonly baseDirectory: string;
    readonly buildDirectory: string;
    readonly outputDirectory: string;
    readonly dependenciesClassPath: ClassPath;
    constructor(baseDir: string, buildDirectory: string, outputDirectory: string, dependenciesClassPath: ClassPath);
    getClassPath(): ClassPath;
}
export declare class MavenProject {
    readonly baseDir: string;
    readonly modules: MavenModule[];
    constructor(baseDir: string, modules: MavenModule[]);
    getClassPath(): string;
}
export declare function makeMavenModule(baseDir: string, args?: string[]): Promise<MavenModule>;
export declare function makeMavenProject(baseDir: string, customMavenArgs?: string[]): Promise<MavenProject>;
