"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateCredentials = void 0;
const api_token_1 = require("../../../lib/api-token");
function validateCredentials(options) {
    try {
        api_token_1.apiTokenExists();
    }
    catch (err) {
        if (api_token_1.getOAuthToken()) {
            return;
        }
        else if (options.docker && api_token_1.getDockerToken()) {
            options.testDepGraphDockerEndpoint = '/docker-jwt/test-dependencies';
            options.isDockerUser = true;
        }
        else {
            throw err;
        }
    }
}
exports.validateCredentials = validateCredentials;
//# sourceMappingURL=validate-credentials.js.map