"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateOptions = void 0;
const config = require("./config");
const reachableVulns = require("./reachable-vulns");
const is_multi_project_scan_1 = require("./is-multi-project-scan");
const errors_1 = require("./errors");
const alerts = require("./alerts");
async function validateOptions(options, packageManager) {
    if (options.reachableVulns) {
        // Throwing error only in case when both packageManager and allProjects not defined
        if (!packageManager && !is_multi_project_scan_1.isMultiProjectScan(options)) {
            throw new Error('Could not determine package manager');
        }
        const org = options.org || config.org;
        try {
            await reachableVulns.validatePayload(org, options, packageManager);
        }
        catch (err) {
            if (err instanceof errors_1.FeatureNotSupportedByPackageManagerError &&
                err.feature === 'Reachable vulns' &&
                err.userMessage) {
                alerts.registerAlerts([
                    {
                        type: 'error',
                        name: 'pkgman-not-supported',
                        msg: err.userMessage,
                    },
                ]);
            }
            else {
                throw err;
            }
        }
    }
}
exports.validateOptions = validateOptions;
//# sourceMappingURL=options-validator.js.map