"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeatureNotSupportedBySnykCodeError = void 0;
const custom_error_1 = require("../../../errors/custom-error");
class FeatureNotSupportedBySnykCodeError extends custom_error_1.CustomError {
    constructor(feature, additionalUserHelp = '') {
        super(`Unsupported action for ${feature}.`);
        this.code = 422;
        this.feature = feature;
        this.userMessage = `'${feature}' is not supported for snyk code. ${additionalUserHelp}`;
    }
}
exports.FeatureNotSupportedBySnykCodeError = FeatureNotSupportedBySnykCodeError;
//# sourceMappingURL=unsupported-feature-snyk-code-error.js.map