"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FAIL_ON = exports.getLegacySeveritiesColour = exports.getSeveritiesColour = exports.defaultSeverityColor = exports.legacySeveritiesColourMapping = exports.severitiesColourMapping = exports.SEVERITIES = exports.SEVERITY = exports.assembleQueryString = void 0;
const config = require("../config");
const chalk_1 = require("chalk");
function assembleQueryString(options) {
    const org = options.org || config.org || null;
    const qs = {
        org,
    };
    if (options.severityThreshold) {
        qs.severityThreshold = options.severityThreshold;
    }
    if (options['ignore-policy']) {
        qs.ignorePolicy = true;
    }
    return Object.keys(qs).length !== 0 ? qs : null;
}
exports.assembleQueryString = assembleQueryString;
var SEVERITY;
(function (SEVERITY) {
    SEVERITY["LOW"] = "low";
    SEVERITY["MEDIUM"] = "medium";
    SEVERITY["HIGH"] = "high";
    SEVERITY["CRITICAL"] = "critical";
})(SEVERITY = exports.SEVERITY || (exports.SEVERITY = {}));
exports.SEVERITIES = [
    {
        verboseName: SEVERITY.LOW,
        value: 1,
    },
    {
        verboseName: SEVERITY.MEDIUM,
        value: 2,
    },
    {
        verboseName: SEVERITY.HIGH,
        value: 3,
    },
    {
        verboseName: SEVERITY.CRITICAL,
        value: 4,
    },
];
exports.severitiesColourMapping = {
    low: {
        colorFunc(text) {
            return chalk_1.default.blueBright(text);
        },
    },
    medium: {
        colorFunc(text) {
            return chalk_1.default.yellowBright(text);
        },
    },
    high: {
        colorFunc(text) {
            return chalk_1.default.redBright(text);
        },
    },
    critical: {
        colorFunc(text) {
            return chalk_1.default.magentaBright(text);
        },
    },
};
exports.legacySeveritiesColourMapping = {
    low: {
        colorFunc(text) {
            return chalk_1.default.bold.blue(text);
        },
    },
    medium: {
        colorFunc(text) {
            return chalk_1.default.bold.yellow(text);
        },
    },
    high: {
        colorFunc(text) {
            return chalk_1.default.bold.red(text);
        },
    },
    critical: {
        colorFunc(text) {
            return chalk_1.default.bold.magenta(text);
        },
    },
};
exports.defaultSeverityColor = {
    colorFunc(text) {
        return chalk_1.default.grey(text);
    },
};
function getSeveritiesColour(severity) {
    return exports.severitiesColourMapping[severity] || exports.defaultSeverityColor;
}
exports.getSeveritiesColour = getSeveritiesColour;
function getLegacySeveritiesColour(severity) {
    return exports.legacySeveritiesColourMapping[severity] || exports.defaultSeverityColor;
}
exports.getLegacySeveritiesColour = getLegacySeveritiesColour;
var FAIL_ON;
(function (FAIL_ON) {
    FAIL_ON["all"] = "all";
    FAIL_ON["upgradable"] = "upgradable";
    FAIL_ON["patchable"] = "patchable";
})(FAIL_ON = exports.FAIL_ON || (exports.FAIL_ON = {}));
//# sourceMappingURL=common.js.map