export interface PluginResponse {
    scanResults: ScanResult[];
}
export interface GitTarget {
    remoteUrl: string;
    branch: string;
}
export interface ContainerTarget {
    image: string;
}
export interface ScanResult {
    identity: Identity;
    facts: Facts[];
    name?: string;
    policy?: string;
    target?: GitTarget | ContainerTarget;
}
export interface Identity {
    type: string;
    targetFile?: string;
    args?: {
        [key: string]: string;
    };
}
export interface Facts {
    type: string;
    data: any;
}
