"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPoetryDependencies = void 0;
const tslib_1 = require("tslib");
const fs = require("fs");
const path = require("path");
const poetry = require("snyk-poetry-lockfile-parser");
const inspect_implementation_1 = require("./inspect-implementation");
const types_1 = require("../types");
function getPoetryDependencies(command, root, targetFile, includeDevDeps = false) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const lockfilePath = path.join(root, targetFile);
        const baseDir = path.dirname(lockfilePath);
        const manifestPath = path.join(baseDir, types_1.FILENAMES.poetry.manifest);
        const manifestExists = fs.existsSync(manifestPath);
        if (!manifestExists) {
            throw new Error('Cannot find manifest file ' + manifestPath);
        }
        const lockfileExists = fs.existsSync(lockfilePath);
        if (!lockfileExists) {
            throw new Error('Cannot find lockfile ' + lockfilePath);
        }
        try {
            const manifestContents = fs.readFileSync(manifestPath, 'utf-8');
            const lockfileContents = fs.readFileSync(lockfilePath, 'utf-8');
            const dependencyGraph = poetry.buildDepGraph(manifestContents, lockfileContents, includeDevDeps);
            const plugin = yield inspect_implementation_1.getMetaData(command, [], root, targetFile);
            return {
                plugin,
                package: null,
                dependencyGraph,
            };
        }
        catch (error) {
            throw new Error('Error processing poetry project. ' + error.message || error);
        }
    });
}
exports.getPoetryDependencies = getPoetryDependencies;
//# sourceMappingURL=poetry.js.map