"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ERROR_CODES = exports.CustomError = void 0;
class CustomError extends Error {
    constructor(message, errorCode) {
        super(message);
        this.name = this.constructor.name;
        this.innerError = undefined;
        this.errorCode = errorCode;
    }
}
exports.CustomError = CustomError;
var ERROR_CODES;
(function (ERROR_CODES) {
    ERROR_CODES["UnsupportedTypeError"] = "G10";
    ERROR_CODES["MissingRemediationData"] = "G11";
    ERROR_CODES["MissingFileName"] = "G12";
    ERROR_CODES["FailedToParseManifest"] = "G13";
    ERROR_CODES["CommandFailed"] = "G14";
})(ERROR_CODES = exports.ERROR_CODES || (exports.ERROR_CODES = {}));
//# sourceMappingURL=custom-error.js.map