"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertErrorToUserMessage = void 0;
const unsupported_type_error_1 = require("./unsupported-type-error");
function convertErrorToUserMessage(error) {
    if (error instanceof unsupported_type_error_1.UnsupportedTypeError) {
        return `${error.scanType} is not supported.`;
    }
    return error.message;
}
exports.convertErrorToUserMessage = convertErrorToUserMessage;
//# sourceMappingURL=error-to-user-message.js.map