"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pipenvPipfile = void 0;
const debugLib = require("debug");
const ora = require("ora");
const chalk = require("chalk");
const pipenvPipfileFix = require("@snyk/fix-pipenv-pipfile");
const update_dependencies_1 = require("./update-dependencies");
const debug = debugLib('snyk-fix:python:Pipfile');
async function pipenvPipfile(fixable, options) {
    debug(`Preparing to fix ${fixable.length} Python Pipfile projects`);
    const handlerResult = {
        succeeded: [],
        failed: [],
        skipped: [],
    };
    await checkPipenvSupport(options);
    for (const [index, entity] of fixable.entries()) {
        const spinner = ora({ isSilent: options.quiet, stream: process.stdout });
        const spinnerMessage = `Fixing Pipfile ${index + 1}/${fixable.length}`;
        spinner.text = spinnerMessage;
        spinner.start();
        const { failed, succeeded, skipped } = await update_dependencies_1.updateDependencies(entity, options);
        handlerResult.succeeded.push(...succeeded);
        handlerResult.failed.push(...failed);
        handlerResult.skipped.push(...skipped);
        spinner.stop();
    }
    return handlerResult;
}
exports.pipenvPipfile = pipenvPipfile;
async function checkPipenvSupport(options) {
    const { version } = await pipenvPipfileFix.isPipenvInstalled();
    const spinner = ora({ isSilent: options.quiet, stream: process.stdout });
    spinner.clear();
    spinner.text = 'Checking pipenv version';
    spinner.indent = 2;
    spinner.start();
    if (!version) {
        spinner.stopAndPersist({
            text: chalk.hex('#EDD55E')('Could not detect pipenv version, proceeding anyway. Some operations may fail.'),
            symbol: chalk.hex('#EDD55E')('⚠️'),
        });
        return;
    }
    const { supported, versions } = pipenvPipfileFix.isPipenvSupportedVersion(version);
    if (!supported) {
        const spinnerMessage = ` ${version} pipenv version detected. Currently the following pipenv versions are supported: ${versions.join(',')}`;
        spinner.stopAndPersist({
            text: chalk.hex('#EDD55E')(spinnerMessage),
            symbol: chalk.hex('#EDD55E')('⚠️'),
        });
    }
    else {
        spinner.stop();
    }
}
//# sourceMappingURL=index.js.map