"use strict";

require("core-js/modules/es.promise.js");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _path = _interopRequireDefault(require("path"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _webpack = require("webpack");

var _dotenvWebpack = _interopRequireDefault(require("dotenv-webpack"));

var _htmlWebpackPlugin = _interopRequireDefault(require("html-webpack-plugin"));

var _caseSensitivePathsWebpackPlugin = _interopRequireDefault(require("case-sensitive-paths-webpack-plugin"));

var _pnpWebpackPlugin = _interopRequireDefault(require("pnp-webpack-plugin"));

var _webpackVirtualModules = _interopRequireDefault(require("webpack-virtual-modules"));

var _terserWebpackPlugin = _interopRequireDefault(require("terser-webpack-plugin"));

var _paths = _interopRequireDefault(require("@storybook/theming/paths"));

var _paths2 = _interopRequireDefault(require("@storybook/ui/paths"));

var _readPkgUp = _interopRequireDefault(require("read-pkg-up"));

var _coreCommon = require("@storybook/core-common");

var _babelLoaderManager = require("./babel-loader-manager");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _default = async function _default({
  configDir: configDir,
  configType: configType,
  docsMode: docsMode,
  entries: entries,
  refs: refs,
  outputDir: outputDir,
  previewUrl: previewUrl,
  versionCheck: versionCheck,
  releaseNotesData: releaseNotesData,
  presets: presets
}) {
  var envs = await presets.apply('env');
  var logLevel = await presets.apply('logLevel', undefined);
  var template = await presets.apply('managerMainTemplate', (0, _coreCommon.getManagerMainTemplate)());
  var headHtmlSnippet = await presets.apply('managerHead', (0, _coreCommon.getManagerHeadTemplate)(configDir, process.env));
  var isProd = configType === 'PRODUCTION';

  var refsTemplate = _fsExtra.default.readFileSync(_path.default.join(__dirname, 'virtualModuleRef.template.js'), {
    encoding: 'utf8'
  });

  var _await$readPackage = await (0, _readPkgUp.default)({
    cwd: __dirname
  }),
      version = _await$readPackage.packageJson.version; // @ts-ignore
  // const { BundleAnalyzerPlugin } = await import('webpack-bundle-analyzer').catch(() => ({}));


  return {
    name: 'manager',
    mode: isProd ? 'production' : 'development',
    bail: isProd,
    devtool: false,
    entry: entries,
    output: {
      path: outputDir,
      filename: isProd ? '[name].[contenthash].manager.bundle.js' : '[name].manager.bundle.js',
      publicPath: ''
    },
    watchOptions: {
      aggregateTimeout: 2000,
      ignored: /node_modules/
    },
    plugins: [refs ? new _webpackVirtualModules.default({
      [_path.default.resolve(_path.default.join(configDir, `generated-refs.js`))]: refsTemplate.replace(`'{{refs}}'`, JSON.stringify(refs))
    }) : null, new _htmlWebpackPlugin.default({
      filename: `index.html`,
      // FIXME: `none` isn't a known option
      chunksSortMode: 'none',
      alwaysWriteToDisk: true,
      inject: false,
      templateParameters: function (compilation, files, options) {
        return {
          compilation: compilation,
          files: files,
          options: options,
          version: version,
          globals: {
            CONFIG_TYPE: configType,
            LOGLEVEL: logLevel,
            VERSIONCHECK: JSON.stringify(versionCheck),
            RELEASE_NOTES_DATA: JSON.stringify(releaseNotesData),
            DOCS_MODE: docsMode,
            // global docs mode
            PREVIEW_URL: previewUrl // global preview URL

          },
          headHtmlSnippet: headHtmlSnippet
        };
      },
      template: template
    }), new _caseSensitivePathsWebpackPlugin.default(), new _dotenvWebpack.default({
      silent: true
    }), // graphql sources check process variable
    new _webpack.DefinePlugin({
      'process.env': (0, _coreCommon.stringifyEnvs)(envs),
      NODE_ENV: JSON.stringify(envs.NODE_ENV)
    }) // isProd &&
    //   BundleAnalyzerPlugin &&
    //   new BundleAnalyzerPlugin({ analyzerMode: 'static', openAnalyzer: false }),
    ].filter(Boolean),
    module: {
      rules: [(0, _babelLoaderManager.babelLoader)(), (0, _coreCommon.es6Transpiler)(), {
        test: /\.css$/,
        use: [require.resolve('style-loader'), {
          loader: require.resolve('css-loader'),
          options: {
            importLoaders: 1
          }
        }]
      }, {
        test: /\.(svg|ico|jpg|jpeg|png|apng|gif|eot|otf|webp|ttf|woff|woff2|cur|ani|pdf)(\?.*)?$/,
        loader: require.resolve('file-loader'),
        options: {
          name: isProd ? 'static/media/[name].[contenthash:8].[ext]' : 'static/media/[path][name].[ext]'
        }
      }, {
        test: /\.(mp4|webm|wav|mp3|m4a|aac|oga)(\?.*)?$/,
        loader: require.resolve('url-loader'),
        options: {
          limit: 10000,
          name: isProd ? 'static/media/[name].[contenthash:8].[ext]' : 'static/media/[path][name].[ext]'
        }
      }]
    },
    resolve: {
      extensions: ['.mjs', '.js', '.jsx', '.json', '.cjs', '.ts', '.tsx'],
      modules: ['node_modules'].concat(envs.NODE_PATH || []),
      mainFields: ['browser', 'module', 'main'],
      alias: _objectSpread(_objectSpread({}, _paths.default), _paths2.default),
      plugins: [// Transparently resolve packages via PnP when needed; noop otherwise
      _pnpWebpackPlugin.default]
    },
    resolveLoader: {
      plugins: [_pnpWebpackPlugin.default.moduleLoader(module)]
    },
    recordsPath: (0, _coreCommon.resolvePathInStorybookCache)('public/records.json'),
    performance: {
      hints: false
    },
    optimization: {
      splitChunks: {
        chunks: 'all'
      },
      runtimeChunk: true,
      sideEffects: true,
      usedExports: true,
      concatenateModules: true,
      minimizer: isProd ? [new _terserWebpackPlugin.default({
        parallel: true,
        terserOptions: {
          mangle: false,
          sourceMap: true,
          keep_fnames: true
        }
      })] : []
    }
  };
};

exports.default = _default;