"use strict";

require("core-js/modules/es.promise.js");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearManagerCache = exports.useManagerCache = void 0;

var _telejson = require("telejson");

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var useManagerCache = async function (fsc, managerConfig) {
  // Drop the `cache` property because it'll change as a result of writing to the cache.
  var _ = managerConfig.cache,
      baseConfig = _objectWithoutProperties(managerConfig, ["cache"]);

  var configString = (0, _telejson.stringify)(baseConfig);
  var cachedConfig = await fsc.get('managerConfig').catch(function () {});
  await fsc.set('managerConfig', configString);
  return configString === cachedConfig;
};

exports.useManagerCache = useManagerCache;

var clearManagerCache = async function (fsc) {
  if (fsc && fsc.fileExists('managerConfig')) {
    await fsc.remove('managerConfig');
    return true;
  }

  return false;
};

exports.clearManagerCache = clearManagerCache;