"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildDepGraph = void 0;
const manifest = require("./manifest-parser");
const lockFile = require("./lock-file-parser");
const poetryDepGraphBuilder = require("./poetry-dep-graph-builder");
function buildDepGraph(manifestFileContents, lockFileContents, includeDevDependencies = false) {
    const dependencyNames = manifest.getDependencyNamesFrom(manifestFileContents, includeDevDependencies);
    const pkgDetails = manifest.pkgInfoFrom(manifestFileContents);
    const pkgSpecs = lockFile.packageSpecsFrom(lockFileContents);
    return poetryDepGraphBuilder.build(pkgDetails, dependencyNames, pkgSpecs);
}
exports.buildDepGraph = buildDepGraph;
//# sourceMappingURL=index.js.map