"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSupportedUtilityType = isSupportedUtilityType;
exports.unwrapUtilityType = unwrapUtilityType;

var _astTypes = require("ast-types");

/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 */
const supportedUtilityTypes = new Set(['$Exact', '$ReadOnly']);
/**
 * See `supportedUtilityTypes` for which types are supported and
 * https://flow.org/en/docs/types/utilities/ for which types are available.
 */

function isSupportedUtilityType(path) {
  if (_astTypes.namedTypes.GenericTypeAnnotation.check(path.node)) {
    const idPath = path.get('id');
    return !!idPath && supportedUtilityTypes.has(idPath.node.name);
  }

  return false;
}
/**
 * Unwraps well known utility types. For example:
 *
 *   $ReadOnly<T> => T
 */


function unwrapUtilityType(path) {
  while (isSupportedUtilityType(path)) {
    path = path.get('typeParameters', 'params', 0);
  }

  return path;
}