import { Token } from 'esprima';
import { LineLocation } from '../../types';
declare type Prop = string | number | undefined;
interface IteratorToken extends Token {
    loc?: any;
}
export default class JsonIterator {
    private tokens;
    private i;
    private currentToken;
    private done;
    private previousProps;
    private lastProp;
    constructor(fileContent: string);
    [Symbol.iterator](): this;
    isCurrentType(type: string): boolean;
    isCurrentValue(value: string): boolean;
    expectType(type: string): void;
    expectValue(value: string): void;
    skipComments(): void;
    next(): void;
    current(): IteratorToken;
    getCurrentLocation(): LineLocation;
    setLastProp(prop: Prop): void;
    pushLastProp(): void;
    restoreProp(): void;
    getLastProp(): string;
}
export {};
