"use strict";

require("core-js/modules/es.function.name.js");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inferControls = void 0;

var _mapValues = _interopRequireDefault(require("lodash/mapValues"));

var _parameters = require("./parameters");

var _filterArgTypes = require("./filterArgTypes");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var inferControl = function inferControl(argType, name, matchers) {
  var type = argType.type,
      options = argType.options;

  if (!type && !options) {
    return undefined;
  } // args that end with background or color e.g. iconColor


  if (matchers.color && matchers.color.test(name)) {
    return {
      control: {
        type: 'color'
      }
    };
  } // args that end with date e.g. purchaseDate


  if (matchers.date && matchers.date.test(name)) {
    return {
      control: {
        type: 'date'
      }
    };
  }

  switch (type.name) {
    case 'array':
      return {
        control: {
          type: 'object'
        }
      };

    case 'boolean':
      return {
        control: {
          type: 'boolean'
        }
      };

    case 'string':
      return {
        control: {
          type: 'text'
        }
      };

    case 'number':
      return {
        control: {
          type: 'number'
        }
      };

    case 'enum':
      {
        var _ref = type,
            value = _ref.value;
        return {
          control: {
            type: (value === null || value === void 0 ? void 0 : value.length) <= 5 ? 'radio' : 'select'
          },
          options: value
        };
      }

    case 'function':
    case 'symbol':
    case 'void':
      return null;

    default:
      return {
        control: {
          type: options ? 'select' : 'object'
        }
      };
  }
};

var inferControls = function inferControls(context) {
  var _context$parameters = context.parameters,
      __isArgsStory = _context$parameters.__isArgsStory,
      argTypes = _context$parameters.argTypes,
      _context$parameters$c = _context$parameters.controls;
  _context$parameters$c = _context$parameters$c === void 0 ? {} : _context$parameters$c;
  var _context$parameters$c2 = _context$parameters$c.include,
      include = _context$parameters$c2 === void 0 ? null : _context$parameters$c2,
      _context$parameters$c3 = _context$parameters$c.exclude,
      exclude = _context$parameters$c3 === void 0 ? null : _context$parameters$c3,
      _context$parameters$c4 = _context$parameters$c.matchers,
      matchers = _context$parameters$c4 === void 0 ? {} : _context$parameters$c4;
  if (!__isArgsStory) return argTypes;
  var filteredArgTypes = (0, _filterArgTypes.filterArgTypes)(argTypes, include, exclude);
  var withControls = (0, _mapValues.default)(filteredArgTypes, function (argType, name) {
    return (argType === null || argType === void 0 ? void 0 : argType.type) && inferControl(argType, name, matchers);
  });
  return (0, _parameters.combineParameters)(withControls, filteredArgTypes);
};

exports.inferControls = inferControls;