"use strict";

require("core-js/modules/es.promise.js");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entries = exports.webpack = void 0;

var _iframeWebpack = _interopRequireDefault(require("../preview/iframe-webpack.config"));

var _entries = require("../preview/entries");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var webpack = async function (_, options) {
  return (0, _iframeWebpack.default)(options);
};

exports.webpack = webpack;

var entries = async function (_, options) {
  var result = [];
  result = result.concat(await (0, _entries.createPreviewEntry)(options));

  if (options.configType === 'DEVELOPMENT') {
    // Suppress informational messages when --quiet is specified. webpack-hot-middleware's quiet
    // parameter would also suppress warnings.
    result = result.concat(`${require.resolve('webpack-hot-middleware/client')}?reload=true&quiet=false&noInfo=${options.quiet}`);
  }

  return result;
};

exports.entries = entries;