import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/NotificationDrawer/notification-drawer';
import { Text, TextVariants } from '../Text';
export const NotificationDrawerHeader = (_ref) => {
  let {
    children,
    className = '',
    count,
    title = 'Notifications',
    unreadText = 'unread'
  } = _ref,
      props = _objectWithoutProperties(_ref, ["children", "className", "count", "title", "unreadText"]);

  return React.createElement("div", _extends({}, props, {
    className: css(styles.notificationDrawerHeader, className)
  }), React.createElement(Text, {
    component: TextVariants.h1,
    className: css(styles.notificationDrawerHeaderTitle)
  }, title), count && React.createElement("span", {
    className: css(styles.notificationDrawerHeaderStatus)
  }, `${count} ${unreadText}`), children && React.createElement("div", {
    className: css(styles.notificationDrawerHeaderAction)
  }, children));
};
NotificationDrawerHeader.propTypes = {
  children: _pt.node,
  className: _pt.string,
  count: _pt.number,
  title: _pt.string,
  unreadText: _pt.string
};
//# sourceMappingURL=NotificationDrawerHeader.js.map