"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDrawerGroup = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _angleRightIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/angle-right-icon"));

var _reactStyles = require("@patternfly/react-styles");

var _notificationDrawer = _interopRequireDefault(require("@patternfly/react-styles/css/components/NotificationDrawer/notification-drawer"));

var _Badge = require("../Badge");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var NotificationDrawerGroup = function NotificationDrawerGroup(_ref) {
  var children = _ref.children,
      _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      count = _ref.count,
      isExpanded = _ref.isExpanded,
      _ref$isRead = _ref.isRead,
      isRead = _ref$isRead === void 0 ? false : _ref$isRead,
      _ref$onExpand = _ref.onExpand,
      onExpand = _ref$onExpand === void 0 ? function (event, expanded) {
    return undefined;
  } : _ref$onExpand,
      title = _ref.title,
      props = _objectWithoutProperties(_ref, ["children", "className", "count", "isExpanded", "isRead", "onExpand", "title"]);

  return React.createElement("section", _extends({}, props, {
    className: (0, _reactStyles.css)(_notificationDrawer["default"].notificationDrawerGroup, isExpanded && _notificationDrawer["default"].modifiers.expanded, className)
  }), React.createElement("h1", null, React.createElement("button", {
    className: (0, _reactStyles.css)(_notificationDrawer["default"].notificationDrawerGroupToggle),
    "aria-expanded": isExpanded,
    onClick: function onClick(e) {
      return onExpand(e, !isExpanded);
    }
  }, React.createElement("div", null, title), React.createElement("div", {
    className: (0, _reactStyles.css)(_notificationDrawer["default"].notificationDrawerGroupToggleCount)
  }, React.createElement(_Badge.Badge, {
    isRead: isRead
  }, count)), React.createElement("span", {
    className: "pf-c-notification-drawer__group-toggle-icon"
  }, React.createElement(_angleRightIcon["default"], null)))), children);
};

exports.NotificationDrawerGroup = NotificationDrawerGroup;
NotificationDrawerGroup.propTypes = {
  children: _propTypes["default"].node,
  className: _propTypes["default"].string,
  count: _propTypes["default"].number.isRequired,
  isExpanded: _propTypes["default"].bool.isRequired,
  isRead: _propTypes["default"].bool,
  onExpand: _propTypes["default"].func,
  title: _propTypes["default"].string.isRequired
};
//# sourceMappingURL=NotificationDrawerGroup.js.map