(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-icons/dist/js/icons/bell-icon", "@patternfly/react-icons/dist/js/icons/check-circle-icon", "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon", "@patternfly/react-icons/dist/js/icons/exclamation-triangle-icon", "@patternfly/react-icons/dist/js/icons/info-circle-icon", "@patternfly/react-styles", "@patternfly/react-styles/css/components/NotificationDrawer/notification-drawer", "@patternfly/react-styles/css/utilities/Accessibility/accessibility"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-icons/dist/js/icons/bell-icon"), require("@patternfly/react-icons/dist/js/icons/check-circle-icon"), require("@patternfly/react-icons/dist/js/icons/exclamation-circle-icon"), require("@patternfly/react-icons/dist/js/icons/exclamation-triangle-icon"), require("@patternfly/react-icons/dist/js/icons/info-circle-icon"), require("@patternfly/react-styles"), require("@patternfly/react-styles/css/components/NotificationDrawer/notification-drawer"), require("@patternfly/react-styles/css/utilities/Accessibility/accessibility"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.bellIcon, global.checkCircleIcon, global.exclamationCircleIcon, global.exclamationTriangleIcon, global.infoCircleIcon, global.reactStyles, global.notificationDrawer, global.accessibility);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _bellIcon, _checkCircleIcon, _exclamationCircleIcon, _exclamationTriangleIcon, _infoCircleIcon, _reactStyles, _notificationDrawer, _accessibility) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.NotificationDrawerListItemHeader = exports.variantIcons = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _bellIcon2 = _interopRequireDefault(_bellIcon);

  var _checkCircleIcon2 = _interopRequireDefault(_checkCircleIcon);

  var _exclamationCircleIcon2 = _interopRequireDefault(_exclamationCircleIcon);

  var _exclamationTriangleIcon2 = _interopRequireDefault(_exclamationTriangleIcon);

  var _infoCircleIcon2 = _interopRequireDefault(_infoCircleIcon);

  var _notificationDrawer2 = _interopRequireDefault(_notificationDrawer);

  var _accessibility2 = _interopRequireDefault(_accessibility);

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;
    var cache = new WeakMap();

    _getRequireWildcardCache = function () {
      return cache;
    };

    return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }

    var cache = _getRequireWildcardCache();

    if (cache && cache.has(obj)) {
      return cache.get(obj);
    }

    var newObj = {};

    if (obj != null) {
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
    }

    newObj.default = obj;

    if (cache) {
      cache.set(obj, newObj);
    }

    return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  const variantIcons = exports.variantIcons = {
    success: _checkCircleIcon2.default,
    danger: _exclamationCircleIcon2.default,
    warning: _exclamationTriangleIcon2.default,
    info: _infoCircleIcon2.default,
    default: _bellIcon2.default
  };

  const NotificationDrawerListItemHeader = exports.NotificationDrawerListItemHeader = _ref => {
    let {
      children,
      className = '',
      icon = null,
      srTitle,
      title,
      variant = 'default'
    } = _ref,
        props = _objectWithoutProperties(_ref, ["children", "className", "icon", "srTitle", "title", "variant"]);

    const Icon = variantIcons[variant];
    return React.createElement(React.Fragment, null, React.createElement("div", _extends({}, props, {
      className: (0, _reactStyles.css)(_notificationDrawer2.default.notificationDrawerListItemHeader, className)
    }), React.createElement("span", {
      className: (0, _reactStyles.css)(_notificationDrawer2.default.notificationDrawerListItemHeaderIcon)
    }, icon ? icon : React.createElement(Icon, null)), React.createElement("h2", {
      className: (0, _reactStyles.css)(_notificationDrawer2.default.notificationDrawerListItemHeaderTitle)
    }, srTitle && React.createElement("span", {
      className: (0, _reactStyles.css)(_accessibility2.default.screenReader)
    }, srTitle), title)), children && React.createElement("div", {
      className: (0, _reactStyles.css)(_notificationDrawer2.default.notificationDrawerListItemAction)
    }, children));
  };

  NotificationDrawerListItemHeader.propTypes = {
    children: _propTypes2.default.node,
    className: _propTypes2.default.string,
    icon: _propTypes2.default.node,
    srTitle: _propTypes2.default.string,
    title: _propTypes2.default.string.isRequired,
    variant: _propTypes2.default.oneOf(['success', 'danger', 'warning', 'info', 'default'])
  };
});
//# sourceMappingURL=NotificationDrawerListItemHeader.js.map