import { BoxAlignProperty, AlignItemsProperty, GlobalsNumber, JustifyContentProperty, FlexWrapProperty } from 'csstype';
import * as types from 'typestyle/lib/types';
declare module 'typestyle/lib/types' {
    interface CSSProperties {
        '-ms-flex-align'?: BoxAlignProperty;
        '-ms-flex-item-align'?: AlignItemsProperty;
        '-ms-flex-wrap'?: FlexWrapProperty;
        '-ms-flex-negative'?: GlobalsNumber;
        '-ms-flex-pack'?: JustifyContentProperty;
    }
}
/**
 * If you have more than one child prefer horizontal,vertical
 */
export declare var flexRoot: types.CSSProperties;
/**
 * A general grouping component that has no impact on the parent flexbox properties e.g.
 * <vertical>
 *    <pass>
 *       <content/>
 *    </pass>
 * </vertical>
 */
export declare var pass: types.CSSProperties;
export declare var inlineRoot: types.CSSProperties;
export declare const horizontal: types.CSSProperties;
export declare const vertical: types.CSSProperties;
export declare var wrap: types.CSSProperties;
/**
 * If you want items to be sized automatically by their children use this
 * This is because of a bug in various flexbox implementations: http://philipwalton.com/articles/normalizing-cross-browser-flexbox-bugs/
 * Specifically bug 1 : https://github.com/philipwalton/flexbugs#1-minimum-content-sizing-of-flex-items-not-honored
 */
export declare var content: types.CSSProperties;
export declare var flex: types.CSSProperties;
export declare var flex1: types.CSSProperties;
export declare var flex2: types.CSSProperties;
export declare var flex3: types.CSSProperties;
export declare var flex4: types.CSSProperties;
export declare var flex5: types.CSSProperties;
export declare var flex6: types.CSSProperties;
export declare var flex7: types.CSSProperties;
export declare var flex8: types.CSSProperties;
export declare var flex9: types.CSSProperties;
export declare var flex10: types.CSSProperties;
export declare var flex11: types.CSSProperties;
export declare var flex12: types.CSSProperties;
export declare var start: types.CSSProperties;
export declare var center: types.CSSProperties;
export declare var end: types.CSSProperties;
export declare var startJustified: types.CSSProperties;
export declare var centerJustified: types.CSSProperties;
export declare var endJustified: types.CSSProperties;
export declare var aroundJustified: types.CSSProperties;
export declare var betweenJustified: types.CSSProperties;
export declare var centerCenter: types.CSSProperties;
export declare var selfStart: types.CSSProperties;
export declare var selfCenter: types.CSSProperties;
export declare var selfEnd: types.CSSProperties;
export declare var selfStretch: types.CSSProperties;
